/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.parser;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.DataStructure;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.ObsParser;
import sdmxdl.ext.spi.SdmxDialect;
import sdmxdl.file.SdmxFileSource;
import sdmxdl.file.spi.SdmxFileContext;
import sdmxdl.util.parser.DefaultObsParser;
import sdmxdl.util.parser.FreqFactory;
import sdmxdl.util.parser.PeriodParsers;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;

public enum ObsFactories implements ObsFactory
{
    SDMX20{

        public @NonNull ObsParser getObsParser(@NonNull DataStructure dsd) {
            Objects.requireNonNull(dsd);
            return new DefaultObsParser(FreqFactory.sdmx20(dsd), PeriodParsers::onStandardFreq, (Parser<Double>)Parser.onDouble());
        }
    }
    ,
    SDMX21{

        public @NonNull ObsParser getObsParser(@NonNull DataStructure dsd) {
            Objects.requireNonNull(dsd);
            return new DefaultObsParser(FreqFactory.sdmx21(dsd), PeriodParsers::onStandardFreq, (Parser<Double>)Parser.onDouble());
        }
    };


    private static Optional<ObsFactory> lookupObsFactory(List<SdmxDialect> dialects, String name) {
        return dialects.stream().filter(dialect -> dialect.getName().equals(name)).findFirst().map(SdmxDialect::getObsFactory);
    }

    public static @Nullable ObsFactory getObsFactory(@NonNull SdmxFileContext context, @NonNull SdmxFileSource source) throws IOException {
        String dialectName = source.getDialect();
        if (dialectName == null) {
            return null;
        }
        return ObsFactories.lookupObsFactory(context.getDialects(), dialectName).orElseThrow(() -> new IOException("Failed to find a suitable dialect for '" + source + "'"));
    }

    public static @NonNull ObsFactory getObsFactory(@NonNull SdmxWebContext context, @NonNull SdmxWebSource source, @NonNull String defaultDialect) throws IOException {
        String dialectName = source.getDialect() != null ? source.getDialect() : defaultDialect;
        return ObsFactories.lookupObsFactory(context.getDialects(), dialectName).orElseThrow(() -> new IOException("Failed to find a suitable dialect for '" + source + "'"));
    }
}

