/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.parser;

import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import lombok.Generated;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataStructure;
import sdmxdl.Dimension;
import sdmxdl.Frequency;
import sdmxdl.Key;
import sdmxdl.util.parser.FreqParsers;

public final class FreqFactory
implements BiFunction<Key.Builder, UnaryOperator<String>, Frequency> {
    @lombok.NonNull
    private final BiFunction<Key.Builder, UnaryOperator<String>, String> extractor;
    @lombok.NonNull
    private final Parser<Frequency> parser;
    public static final String FREQ_CONCEPT = "FREQ";
    public static final String TIME_FORMAT_CONCEPT = "TIME_FORMAT";
    public static final int NO_FREQUENCY_CODE_ID_INDEX = -1;

    @Override
    public Frequency apply(Key.Builder k, UnaryOperator<String> a) {
        Frequency freq = (Frequency)this.parser.parse((CharSequence)this.extractor.apply(k, a));
        return freq != null ? freq : Frequency.UNDEFINED;
    }

    public static @NonNull FreqFactory sdmx20(@NonNull DataStructure dsd) {
        return FreqFactory.sdmx20(TIME_FORMAT_CONCEPT);
    }

    public static @NonNull FreqFactory sdmx20(@NonNull String attributeName) {
        return FreqFactory.builder().extractorByAttribute(attributeName).parser(FreqParsers.onTimeFormatCodeList()).build();
    }

    public static @NonNull FreqFactory sdmx21(@NonNull DataStructure dsd) {
        return FreqFactory.sdmx21(FreqFactory.getFrequencyCodeIdIndex(dsd));
    }

    public static @NonNull FreqFactory sdmx21(int frequencyCodeIdIndex) {
        return FreqFactory.builder().extractorByDimension(frequencyCodeIdIndex).parser(FreqParsers.onFreqCodeList()).build();
    }

    public static int getFrequencyCodeIdIndex(@NonNull DataStructure dsd) {
        for (Dimension o : dsd.getDimensions()) {
            switch (o.getId()) {
                case "FREQ": 
                case "FREQUENCY": {
                    return o.getPosition() - 1;
                }
            }
        }
        return -1;
    }

    @Generated
    FreqFactory(@lombok.NonNull BiFunction<Key.Builder, UnaryOperator<String>, String> extractor, @lombok.NonNull Parser<Frequency> parser) {
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        this.extractor = extractor;
        this.parser = parser;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().extractor(this.extractor).parser(this.parser);
    }

    public static final class Builder {
        @Generated
        private BiFunction<Key.Builder, UnaryOperator<String>, String> extractor;
        @Generated
        private Parser<Frequency> parser;

        public Builder extractorByAttribute(@NonNull String attributeName) {
            return this.extractor((k, a) -> (String)a.apply(attributeName));
        }

        public Builder extractorByDimension(int index) {
            return this.extractor(index != -1 ? (k, a) -> k.getItem(index) : (k, a) -> null);
        }

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder extractor(@lombok.NonNull BiFunction<Key.Builder, UnaryOperator<String>, String> extractor) {
            if (extractor == null) {
                throw new NullPointerException("extractor is marked non-null but is null");
            }
            this.extractor = extractor;
            return this;
        }

        @Generated
        public @NonNull Builder parser(@lombok.NonNull Parser<Frequency> parser) {
            if (parser == null) {
                throw new NullPointerException("parser is marked non-null but is null");
            }
            this.parser = parser;
            return this;
        }

        @Generated
        public @NonNull FreqFactory build() {
            return new FreqFactory(this.extractor, this.parser);
        }

        @Generated
        public @NonNull String toString() {
            return "FreqFactory.Builder(extractor=" + this.extractor + ", parser=" + this.parser + ")";
        }
    }
}

