/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.file;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataCursor;
import sdmxdl.DataFilter;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.SdmxCache;
import sdmxdl.file.SdmxFileSource;
import sdmxdl.repo.DataSet;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.util.TypedId;
import sdmxdl.util.file.SdmxFileClient;
import sdmxdl.util.file.SdmxFileInfo;

public final class CachedFileClient
implements SdmxFileClient {
    public static final Duration DEFAULT_CACHE_TTL = Duration.ofMinutes(5L);
    @lombok.NonNull
    private final SdmxFileClient delegate;
    @lombok.NonNull
    private final SdmxCache cache;
    @lombok.NonNull
    private final String base;
    private final AtomicReference<Object> idOfDecode = new AtomicReference();
    private final AtomicReference<Object> idOfLoadData = new AtomicReference();

    public static @NonNull CachedFileClient of(@NonNull SdmxFileClient client, @NonNull SdmxCache cache, @NonNull SdmxFileSource source, @NonNull LanguagePriorityList languages) {
        return new CachedFileClient(client, cache, CachedFileClient.getBase(source, languages));
    }

    private static String getBase(SdmxFileSource source, LanguagePriorityList languages) {
        return source.getData().toString() + source.getStructure() + languages;
    }

    private static TypedId<SdmxFileInfo> initIdOfDecode(String base) {
        return TypedId.of("decode://" + base, repo -> SdmxFileInfo.of(repo.getName(), repo.getStructures().stream().findFirst().orElse(null)), info -> SdmxRepository.builder().name(info.getDataType()).structure(info.getStructure()).build());
    }

    private static TypedId<DataSet> initIdOfLoadData(String base) {
        return TypedId.of("loadData://" + base, repo -> repo.getDataSets().stream().findFirst().orElse(null), data -> SdmxRepository.builder().dataSet(data).build());
    }

    @Override
    public SdmxFileInfo decode() throws IOException {
        return this.getIdOfDecode().load(this.cache, (IOSupplier<SdmxFileInfo>)((IOSupplier)this.delegate::decode), this::getTtl);
    }

    @Override
    public DataCursor loadData(SdmxFileInfo entry, DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        return !filter.getDetail().isDataRequested() ? this.getIdOfLoadData().load(this.cache, (IOSupplier<DataSet>)((IOSupplier)() -> this.copyAllNoData(entry, flowRef)), this::getTtl).getDataCursor(key, filter) : this.delegate.loadData(entry, flowRef, key, filter);
    }

    private Duration getTtl(Object o) {
        return DEFAULT_CACHE_TTL;
    }

    private DataSet copyAllNoData(SdmxFileInfo entry, DataflowRef flowRef) throws IOException {
        try (DataCursor cursor = this.delegate.loadData(entry, flowRef, Key.ALL, DataFilter.NO_DATA);){
            DataSet dataSet = DataSet.builder().ref(flowRef).copyOf(cursor).build();
            return dataSet;
        }
    }

    @Generated
    public CachedFileClient(@lombok.NonNull SdmxFileClient delegate, @lombok.NonNull SdmxCache cache, @lombok.NonNull String base) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        this.delegate = delegate;
        this.cache = cache;
        this.base = base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<SdmxFileInfo> getIdOfDecode() {
        Object value = this.idOfDecode.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfDecode;
            synchronized (atomicReference) {
                value = this.idOfDecode.get();
                if (value == null) {
                    TypedId<SdmxFileInfo> actualValue = CachedFileClient.initIdOfDecode(this.base);
                    value = actualValue == null ? this.idOfDecode : actualValue;
                    this.idOfDecode.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfDecode ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<DataSet> getIdOfLoadData() {
        Object value = this.idOfLoadData.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfLoadData;
            synchronized (atomicReference) {
                value = this.idOfLoadData.get();
                if (value == null) {
                    TypedId<DataSet> actualValue = CachedFileClient.initIdOfLoadData(this.base);
                    value = actualValue == null ? this.idOfLoadData : actualValue;
                    this.idOfLoadData.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfLoadData ? null : value);
    }
}

