/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.util.ext.ExpiringRepository;

public interface Serializer {
    public @NonNull ExpiringRepository load(@NonNull InputStream var1) throws IOException;

    public void store(@NonNull OutputStream var1, @NonNull ExpiringRepository var2) throws IOException;

    public static @NonNull Serializer noOp() {
        return new Serializer(){

            @Override
            public ExpiringRepository load(@NonNull InputStream stream) {
                return null;
            }

            @Override
            public void store(@NonNull OutputStream stream, ExpiringRepository entry) {
            }
        };
    }

    public static @NonNull Serializer gzip(final @NonNull Serializer delegate) {
        return new Serializer(){

            @Override
            public ExpiringRepository load(@NonNull InputStream stream) throws IOException {
                try (GZIPInputStream gzip = new GZIPInputStream(stream);){
                    ExpiringRepository expiringRepository = delegate.load(gzip);
                    return expiringRepository;
                }
            }

            @Override
            public void store(@NonNull OutputStream stream, ExpiringRepository entry) throws IOException {
                try (GZIPOutputStream gzip = new GZIPOutputStream(stream);){
                    delegate.store(gzip, entry);
                }
            }
        };
    }
}

