/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.ext.SdmxCache;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.util.ext.ExpiringRepository;

public final class MapCache
implements SdmxCache {
    @lombok.NonNull
    private final ConcurrentMap<String, ExpiringRepository> map;
    @lombok.NonNull
    private final Clock clock;

    public static @NonNull MapCache of() {
        return MapCache.of(new ConcurrentHashMap<String, ExpiringRepository>(), Clock.systemDefaultZone());
    }

    public SdmxRepository get(String key) {
        return MapCache.get(this.map, this.clock, key);
    }

    public void put(String key, SdmxRepository value, Duration ttl) {
        MapCache.put(this.map, this.clock, key, value, ttl);
    }

    static @Nullable SdmxRepository get(@NonNull ConcurrentMap<String, ExpiringRepository> map, @NonNull Clock clock, @NonNull String key) {
        ExpiringRepository value = (ExpiringRepository)map.get(key);
        if (value == null) {
            return null;
        }
        if (value.isExpired(clock)) {
            map.remove(key);
            return null;
        }
        return value.getValue();
    }

    static void put(@NonNull ConcurrentMap<String, ExpiringRepository> map, @NonNull Clock clock, @NonNull String key, @NonNull SdmxRepository value, @NonNull Duration ttl) {
        Objects.requireNonNull(value);
        map.put(key, ExpiringRepository.of(clock, ttl, value));
    }

    @lombok.NonNull
    @Generated
    public ConcurrentMap<String, ExpiringRepository> getMap() {
        return this.map;
    }

    @lombok.NonNull
    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    private MapCache(@lombok.NonNull ConcurrentMap<String, ExpiringRepository> map, @lombok.NonNull Clock clock) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.map = map;
        this.clock = clock;
    }

    @Generated
    public static @NonNull MapCache of(@lombok.NonNull ConcurrentMap<String, ExpiringRepository> map, @lombok.NonNull Clock clock) {
        return new MapCache(map, clock);
    }
}

