/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.sys.SystemProperties;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.ext.SdmxCache;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.util.ext.ExpiringRepository;
import sdmxdl.util.ext.Serializer;

public final class FileCache
implements SdmxCache {
    @NonNull
    private final Path root;
    @NonNull
    private final String fileNamePrefix;
    @NonNull
    private final String fileNameSuffix;
    @NonNull
    private final UnaryOperator<String> fileNameGenerator;
    @NonNull
    private final Serializer serializer;
    @NonNull
    private final BiConsumer<String, IOException> onIOException;
    @NonNull
    private final Clock clock;
    private static final UnaryOperator<String> DEFAULT_GENERATOR = key -> String.valueOf(Math.abs(key.hashCode()));
    private static final BiConsumer<String, IOException> DO_NOT_REPORT = (msg, ex) -> {};

    public @Nullable SdmxRepository get(@org.checkerframework.checker.nullness.qual.NonNull String key) {
        ExpiringRepository result = this.read(key);
        if (result == null) {
            return null;
        }
        if (result.isExpired(this.clock)) {
            this.delete(key);
            return null;
        }
        return result.getValue();
    }

    public void put(@org.checkerframework.checker.nullness.qual.NonNull String key, @org.checkerframework.checker.nullness.qual.NonNull SdmxRepository value, @org.checkerframework.checker.nullness.qual.NonNull Duration ttl) {
        this.write(key, ExpiringRepository.of(this.clock, ttl, value));
    }

    private ExpiringRepository read(String key) {
        Path file = this.getFile(key);
        if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            ExpiringRepository expiringRepository;
            block9: {
                InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                try {
                    expiringRepository = this.serializer.load(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        this.onIOException.accept("While reading '" + file + "'", ex);
                    }
                }
                stream.close();
            }
            return expiringRepository;
        }
        return null;
    }

    private void write(String key, ExpiringRepository entry) {
        Path file = this.getFile(key);
        this.ensureParentExists(file);
        try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
            this.serializer.store(stream, entry);
        }
        catch (IOException ex) {
            this.onIOException.accept("While writing '" + file + "'", ex);
        }
    }

    private void ensureParentExists(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.onIOException.accept("While creating working dir '" + file + "'", ex);
        }
    }

    private void delete(String key) {
        Path file = this.getFile(key);
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException ex) {
            this.onIOException.accept("While deleting '" + file + "'", ex);
        }
    }

    Path getFile(String key) {
        return this.root.resolve(this.fileNamePrefix + (String)this.fileNameGenerator.apply(key) + this.fileNameSuffix);
    }

    @Generated
    private static Path $default$root() {
        return SystemProperties.DEFAULT.getJavaIoTmpdir().resolve("sdmxdl");
    }

    @Generated
    private static String $default$fileNamePrefix() {
        return "sdmx_";
    }

    @Generated
    private static String $default$fileNameSuffix() {
        return ".dat";
    }

    @Generated
    private static UnaryOperator<String> $default$fileNameGenerator() {
        return DEFAULT_GENERATOR;
    }

    @Generated
    private static Serializer $default$serializer() {
        return Serializer.noOp();
    }

    @Generated
    private static BiConsumer<String, IOException> $default$onIOException() {
        return DO_NOT_REPORT;
    }

    @Generated
    private static Clock $default$clock() {
        return Clock.systemDefaultZone();
    }

    @Generated
    FileCache(@NonNull Path root, @NonNull String fileNamePrefix, @NonNull String fileNameSuffix, @NonNull UnaryOperator<String> fileNameGenerator, @NonNull Serializer serializer, @NonNull BiConsumer<String, IOException> onIOException, @NonNull Clock clock) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (fileNamePrefix == null) {
            throw new NullPointerException("fileNamePrefix is marked non-null but is null");
        }
        if (fileNameSuffix == null) {
            throw new NullPointerException("fileNameSuffix is marked non-null but is null");
        }
        if (fileNameGenerator == null) {
            throw new NullPointerException("fileNameGenerator is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (onIOException == null) {
            throw new NullPointerException("onIOException is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.root = root;
        this.fileNamePrefix = fileNamePrefix;
        this.fileNameSuffix = fileNameSuffix;
        this.fileNameGenerator = fileNameGenerator;
        this.serializer = serializer;
        this.onIOException = onIOException;
        this.clock = clock;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        return new Builder().root(this.root).fileNamePrefix(this.fileNamePrefix).fileNameSuffix(this.fileNameSuffix).fileNameGenerator(this.fileNameGenerator).serializer(this.serializer).onIOException(this.onIOException).clock(this.clock);
    }

    @NonNull
    @Generated
    public Path getRoot() {
        return this.root;
    }

    @NonNull
    @Generated
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @NonNull
    @Generated
    public String getFileNameSuffix() {
        return this.fileNameSuffix;
    }

    @NonNull
    @Generated
    public UnaryOperator<String> getFileNameGenerator() {
        return this.fileNameGenerator;
    }

    @NonNull
    @Generated
    public Serializer getSerializer() {
        return this.serializer;
    }

    @NonNull
    @Generated
    public BiConsumer<String, IOException> getOnIOException() {
        return this.onIOException;
    }

    @NonNull
    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean root$set;
        @Generated
        private Path root$value;
        @Generated
        private boolean fileNamePrefix$set;
        @Generated
        private String fileNamePrefix$value;
        @Generated
        private boolean fileNameSuffix$set;
        @Generated
        private String fileNameSuffix$value;
        @Generated
        private boolean fileNameGenerator$set;
        @Generated
        private UnaryOperator<String> fileNameGenerator$value;
        @Generated
        private boolean serializer$set;
        @Generated
        private Serializer serializer$value;
        @Generated
        private boolean onIOException$set;
        @Generated
        private BiConsumer<String, IOException> onIOException$value;
        @Generated
        private boolean clock$set;
        @Generated
        private Clock clock$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder root(@NonNull Path root) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            this.root$value = root;
            this.root$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fileNamePrefix(@NonNull String fileNamePrefix) {
            if (fileNamePrefix == null) {
                throw new NullPointerException("fileNamePrefix is marked non-null but is null");
            }
            this.fileNamePrefix$value = fileNamePrefix;
            this.fileNamePrefix$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fileNameSuffix(@NonNull String fileNameSuffix) {
            if (fileNameSuffix == null) {
                throw new NullPointerException("fileNameSuffix is marked non-null but is null");
            }
            this.fileNameSuffix$value = fileNameSuffix;
            this.fileNameSuffix$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fileNameGenerator(@NonNull UnaryOperator<String> fileNameGenerator) {
            if (fileNameGenerator == null) {
                throw new NullPointerException("fileNameGenerator is marked non-null but is null");
            }
            this.fileNameGenerator$value = fileNameGenerator;
            this.fileNameGenerator$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder serializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            this.serializer$value = serializer;
            this.serializer$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder onIOException(@NonNull BiConsumer<String, IOException> onIOException) {
            if (onIOException == null) {
                throw new NullPointerException("onIOException is marked non-null but is null");
            }
            this.onIOException$value = onIOException;
            this.onIOException$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clock(@NonNull Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            this.clock$value = clock;
            this.clock$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull FileCache build() {
            Path root$value = this.root$value;
            if (!this.root$set) {
                root$value = FileCache.$default$root();
            }
            String fileNamePrefix$value = this.fileNamePrefix$value;
            if (!this.fileNamePrefix$set) {
                fileNamePrefix$value = FileCache.$default$fileNamePrefix();
            }
            String fileNameSuffix$value = this.fileNameSuffix$value;
            if (!this.fileNameSuffix$set) {
                fileNameSuffix$value = FileCache.$default$fileNameSuffix();
            }
            UnaryOperator fileNameGenerator$value = this.fileNameGenerator$value;
            if (!this.fileNameGenerator$set) {
                fileNameGenerator$value = FileCache.$default$fileNameGenerator();
            }
            Serializer serializer$value = this.serializer$value;
            if (!this.serializer$set) {
                serializer$value = FileCache.$default$serializer();
            }
            BiConsumer onIOException$value = this.onIOException$value;
            if (!this.onIOException$set) {
                onIOException$value = FileCache.$default$onIOException();
            }
            Clock clock$value = this.clock$value;
            if (!this.clock$set) {
                clock$value = FileCache.$default$clock();
            }
            return new FileCache(root$value, fileNamePrefix$value, fileNameSuffix$value, fileNameGenerator$value, serializer$value, onIOException$value, clock$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "FileCache.Builder(root$value=" + this.root$value + ", fileNamePrefix$value=" + this.fileNamePrefix$value + ", fileNameSuffix$value=" + this.fileNameSuffix$value + ", fileNameGenerator$value=" + this.fileNameGenerator$value + ", serializer$value=" + this.serializer$value + ", onIOException$value=" + this.onIOException$value + ", clock$value=" + this.clock$value + ")";
        }
    }
}

