/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.time.Clock;
import java.time.Duration;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.repo.SdmxRepository;

public final class ExpiringRepository {
    private final long creationTimeInMillis;
    private final long ttlInMillis;
    @lombok.NonNull
    private final SdmxRepository value;

    public static @NonNull ExpiringRepository of(@NonNull Clock clock, @NonNull Duration ttl, @NonNull SdmxRepository value) {
        return ExpiringRepository.of(clock.millis(), ttl.toMillis(), value);
    }

    public boolean isExpired(@NonNull Clock clock) {
        return this.creationTimeInMillis + this.ttlInMillis <= clock.millis();
    }

    @Generated
    private ExpiringRepository(long creationTimeInMillis, long ttlInMillis, @lombok.NonNull SdmxRepository value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.creationTimeInMillis = creationTimeInMillis;
        this.ttlInMillis = ttlInMillis;
        this.value = value;
    }

    @Generated
    public static @NonNull ExpiringRepository of(long creationTimeInMillis, long ttlInMillis, @lombok.NonNull SdmxRepository value) {
        return new ExpiringRepository(creationTimeInMillis, ttlInMillis, value);
    }

    @Generated
    public long getCreationTimeInMillis() {
        return this.creationTimeInMillis;
    }

    @Generated
    public long getTtlInMillis() {
        return this.ttlInMillis;
    }

    @lombok.NonNull
    @Generated
    public SdmxRepository getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpiringRepository)) {
            return false;
        }
        ExpiringRepository other = (ExpiringRepository)o;
        if (this.getCreationTimeInMillis() != other.getCreationTimeInMillis()) {
            return false;
        }
        if (this.getTtlInMillis() != other.getTtlInMillis()) {
            return false;
        }
        SdmxRepository this$value = this.getValue();
        SdmxRepository other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $creationTimeInMillis = this.getCreationTimeInMillis();
        result = result * 59 + (int)($creationTimeInMillis >>> 32 ^ $creationTimeInMillis);
        long $ttlInMillis = this.getTtlInMillis();
        result = result * 59 + (int)($ttlInMillis >>> 32 ^ $ttlInMillis);
        SdmxRepository $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ExpiringRepository(creationTimeInMillis=" + this.getCreationTimeInMillis() + ", ttlInMillis=" + this.getTtlInMillis() + ", value=" + this.getValue() + ")";
    }
}

