/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.ext.SdmxCache;
import sdmxdl.repo.SdmxRepository;

public final class TypedId<T> {
    @lombok.NonNull
    private final String content;
    @lombok.NonNull
    private final Function<SdmxRepository, T> loader;
    @lombok.NonNull
    private final Function<T, SdmxRepository> storer;

    public static <T> @NonNull TypedId<T> of(@NonNull String content, @NonNull Function<SdmxRepository, T> loader, @NonNull Function<T, SdmxRepository> storer) {
        return new TypedId<T>(content, loader, storer);
    }

    public @NonNull TypedId<T> with(@NonNull Object o) {
        Objects.requireNonNull(o);
        return new TypedId<T>(this.content + o, this.loader, this.storer);
    }

    public @Nullable T peek(@NonNull SdmxCache cache) {
        SdmxRepository repo = cache.get(this.content);
        return repo != null ? (T)this.loader.apply(repo) : null;
    }

    public @NonNull T load(@NonNull SdmxCache cache, @NonNull IOSupplier<T> factory, @NonNull Function<? super T, Duration> ttl) throws IOException {
        return (T)this.load(cache, factory, ttl, o -> true);
    }

    public @NonNull T load(@NonNull SdmxCache cache, @NonNull IOSupplier<T> factory, @NonNull Function<? super T, Duration> ttl, @NonNull Predicate<? super T> validator) throws IOException {
        Object result = this.peek(cache);
        if (result == null || !validator.test(result)) {
            result = factory.getWithIO();
            cache.put(this.content, this.storer.apply(result), ttl.apply(result));
        }
        return result;
    }

    @Generated
    private TypedId(@lombok.NonNull String content, @lombok.NonNull Function<SdmxRepository, T> loader, @lombok.NonNull Function<T, SdmxRepository> storer) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        if (storer == null) {
            throw new NullPointerException("storer is marked non-null but is null");
        }
        this.content = content;
        this.loader = loader;
        this.storer = storer;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedId)) {
            return false;
        }
        TypedId other = (TypedId)o;
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Function<SdmxRepository, T> this$loader = this.loader;
        Function<SdmxRepository, T> other$loader = other.loader;
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        Function<T, SdmxRepository> this$storer = this.storer;
        Function<T, SdmxRepository> other$storer = other.storer;
        return !(this$storer == null ? other$storer != null : !this$storer.equals(other$storer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Function<SdmxRepository, T> $loader = this.loader;
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        Function<T, SdmxRepository> $storer = this.storer;
        result = result * 59 + ($storer == null ? 43 : $storer.hashCode());
        return result;
    }

    @lombok.NonNull
    @Generated
    public String getContent() {
        return this.content;
    }
}

