/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.util.ext;

import java.time.LocalDateTime;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataStructure;
import sdmxdl.Frequency;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.ObsParser;
import sdmxdl.ext.spi.SdmxDialect;
import sdmxdl.util.parser.DefaultObsParser;
import sdmxdl.util.parser.FreqFactory;
import sdmxdl.util.parser.PeriodParsers;

public final class InseeDialect
implements SdmxDialect {
    private static final Parser<LocalDateTime> ANNUAL_PARSER = PeriodParsers.onDatePattern("yyyy");
    private static final Parser<LocalDateTime> HALF_YEARLY_PARSER = PeriodParsers.onYearFreqPos("S", 2);
    private static final Parser<LocalDateTime> QUARTERLY_PARSER = PeriodParsers.onYearFreqPos("Q", 4);
    private static final Parser<LocalDateTime> MONTHLY_PARSER = PeriodParsers.onDatePattern("yyyy-MM").orElse(PeriodParsers.onYearFreqPos("B", 12));
    private static final Parser<LocalDateTime> DEFAULT_PARSER = Parser.onNull();

    public String getName() {
        return "INSEE2017";
    }

    public String getDescription() {
        return this.getName();
    }

    public @NonNull ObsFactory getObsFactory() {
        return InseeDialect::getObsParser;
    }

    private static ObsParser getObsParser(DataStructure dsd) {
        return new DefaultObsParser(InseeDialect.getFreqFactory(dsd), InseeDialect::getPeriodParser, (Parser<Double>)Parser.onDouble());
    }

    static FreqFactory getFreqFactory(DataStructure dsd) {
        return FreqFactory.sdmx21(dsd).toBuilder().parser((Parser<Frequency>)((Parser)InseeDialect::parseInseeFreq)).build();
    }

    static Parser<LocalDateTime> getPeriodParser(Frequency freq) {
        return InseeDialect.onInseeTimePeriod(freq);
    }

    private static Frequency parseInseeFreq(CharSequence code) {
        if (code != null && code.length() == 1) {
            switch (code.charAt(0)) {
                case 'A': {
                    return Frequency.ANNUAL;
                }
                case 'S': {
                    return Frequency.HALF_YEARLY;
                }
                case 'T': {
                    return Frequency.QUARTERLY;
                }
                case 'M': {
                    return Frequency.MONTHLY;
                }
                case 'B': {
                    return Frequency.MONTHLY;
                }
            }
        }
        return Frequency.UNDEFINED;
    }

    private static Parser<LocalDateTime> onInseeTimePeriod(Frequency freq) {
        switch (freq) {
            case ANNUAL: {
                return ANNUAL_PARSER;
            }
            case HALF_YEARLY: {
                return HALF_YEARLY_PARSER;
            }
            case QUARTERLY: {
                return QUARTERLY_PARSER;
            }
            case MONTHLY: {
                return MONTHLY_PARSER;
            }
        }
        return DEFAULT_PARSER;
    }
}

