/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.util.ext;

import java.util.Objects;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataStructure;
import sdmxdl.Frequency;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.ObsParser;
import sdmxdl.ext.spi.SdmxDialect;
import sdmxdl.util.parser.DefaultObsParser;
import sdmxdl.util.parser.FreqFactory;
import sdmxdl.util.parser.PeriodParsers;

public final class EcbDialect
implements SdmxDialect {
    public String getName() {
        return "ECB2020";
    }

    public String getDescription() {
        return this.getName();
    }

    public @NonNull ObsFactory getObsFactory() {
        return EcbDialect::getObsParser;
    }

    private static ObsParser getObsParser(DataStructure dsd) {
        Objects.requireNonNull(dsd);
        return new DefaultObsParser(EcbDialect.getFreqFactory(dsd), PeriodParsers::onStandardFreq, (Parser<Double>)Parser.onDouble());
    }

    private static FreqFactory getFreqFactory(DataStructure dsd) {
        return FreqFactory.sdmx21(dsd).toBuilder().parser((Parser<Frequency>)((Parser)EcbDialect::parseFreq)).build();
    }

    private static Frequency parseFreq(CharSequence code) {
        if (code != null && code.length() == 1) {
            switch (code.charAt(0)) {
                case 'A': {
                    return Frequency.ANNUAL;
                }
                case 'H': 
                case 'S': {
                    return Frequency.HALF_YEARLY;
                }
                case 'Q': {
                    return Frequency.QUARTERLY;
                }
                case 'M': {
                    return Frequency.MONTHLY;
                }
                case 'W': {
                    return Frequency.WEEKLY;
                }
                case 'D': {
                    return Frequency.DAILY;
                }
                case 'B': {
                    return Frequency.DAILY_BUSINESS;
                }
                case 'N': {
                    return Frequency.MINUTELY;
                }
            }
            return null;
        }
        return Frequency.UNDEFINED;
    }
}

