/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.sys;

import internal.sdmxdl.sys.WinPasswordVault;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.function.BiConsumer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.sys.OS;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.web.SdmxWebAuthenticator;
import sdmxdl.web.SdmxWebSource;

public final class SdmxSystemUtil {
    public static @Nullable SdmxWebAuthenticator getAuthenticatorOrNull(PasswordAuthentication user, BiConsumer<String, IOException> onIOException) {
        return SdmxSystemUtil.canHandle(user) && OS.NAME.equals((Object)OS.Name.WINDOWS) ? new WinPasswordVaultAuthenticator(onIOException) : null;
    }

    private static boolean canHandle(PasswordAuthentication user) {
        return user.getUserName() == null || user.getUserName().isEmpty();
    }

    @Generated
    private SdmxSystemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class WinPasswordVaultAuthenticator
    implements SdmxWebAuthenticator {
        @NonNull
        private final BiConsumer<String, IOException> onIOException;

        public PasswordAuthentication getPasswordAuthentication(SdmxWebSource source) {
            WinPasswordVault vault = WinPasswordVault.open();
            try {
                String message = "Enter your credentials for " + source.getName();
                PasswordAuthentication passwordAuthentication = this.toPasswordAuthentication(vault.getOrPrompt(this.getResource(source), message, false));
                if (vault != null) {
                    vault.close();
                }
                return passwordAuthentication;
            }
            catch (Throwable throwable) {
                try {
                    if (vault != null) {
                        try {
                            vault.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.onIOException.accept("While getting password", ex);
                    return null;
                }
            }
        }

        public void invalidate(SdmxWebSource source) {
            try (WinPasswordVault vault = WinPasswordVault.open();){
                vault.invalidate(this.getResource(source));
            }
            catch (IOException ex) {
                this.onIOException.accept("While invalidating password", ex);
            }
        }

        private String getResource(SdmxWebSource source) {
            return "sdmx-dl:" + source.getEndpoint().getHost();
        }

        private PasswordAuthentication toPasswordAuthentication(WinPasswordVault.PasswordCredential credential) {
            return credential != null ? new PasswordAuthentication(credential.getUserName(), credential.getPassword()) : null;
        }

        @Generated
        public WinPasswordVaultAuthenticator(@NonNull BiConsumer<String, IOException> onIOException) {
            if (onIOException == null) {
                throw new NullPointerException("onIOException is marked non-null but is null");
            }
            this.onIOException = onIOException;
        }
    }
}

