/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.sys;

import com.github.tuupertunut.powershelllibjava.PowerShell;
import com.github.tuupertunut.powershelllibjava.PowerShellExecutionException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import nbbrd.picocsv.Csv;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WinPasswordVault
implements Closeable {
    @lombok.NonNull
    private final PowerShell psSession = PowerShell.open();

    public static WinPasswordVault open() throws IOException {
        WinPasswordVault result = new WinPasswordVault();
        result.exec(WinPasswordVault.loadCode());
        return result;
    }

    private WinPasswordVault() throws IOException {
    }

    public PasswordCredential getOrPrompt(String resource, String message, boolean force) throws IOException {
        String resourceParam = PowerShell.escapePowerShellString((String)resource);
        String messageParam = PowerShell.escapePowerShellString((String)message);
        String forceParam = force ? "$true" : "$false";
        String result = this.exec("$cred = GetOrPromptCredential -resource " + resourceParam + " -message " + messageParam + " -force " + forceParam, "if ($cred -ne $null) {", "  echo ($cred | Select-Object -Property Resource, UserName, Password | ConvertTo-Csv -NoTypeInformation)", "}");
        return WinPasswordVault.parse(result);
    }

    public void invalidate(String resource) throws IOException {
        String resourceParam = PowerShell.escapePowerShellString((String)resource);
        this.exec("InvalidateCredential -resource " + resourceParam);
    }

    @Override
    public void close() {
        this.psSession.close();
    }

    private String exec(String ... commands) throws IOException {
        try {
            return this.psSession.executeCommands(commands);
        }
        catch (PowerShellExecutionException ex) {
            throw new IOException(ex);
        }
    }

    private static PasswordCredential parse(String csv) throws IOException {
        try (Csv.Reader reader = Csv.Reader.of((Csv.Format)Csv.Format.DEFAULT, (Csv.ReaderOptions)Csv.ReaderOptions.DEFAULT, (Reader)new StringReader(csv), (int)8192);){
            if (reader.readLine() && reader.readLine() && reader.readField()) {
                String resource = reader.toString();
                if (reader.readField()) {
                    String userName = reader.toString();
                    if (reader.readField()) {
                        String password = reader.toString();
                        PasswordCredential passwordCredential = new PasswordCredential(resource, userName, password.toCharArray());
                        return passwordCredential;
                    }
                }
            }
            PasswordCredential passwordCredential = null;
            return passwordCredential;
        }
    }

    private static String[] loadCode() throws IOException {
        try (InputStream stream = WinPasswordVault.class.getResourceAsStream("WinPasswordVault.ps1");){
            String[] stringArray;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                stringArray = (String[])reader.lines().toArray(String[]::new);
            }
            return stringArray;
        }
    }

    public static final class PasswordCredential {
        @lombok.NonNull
        private final String resource;
        @lombok.NonNull
        private final String userName;
        @lombok.NonNull
        private final char[] password;

        @Generated
        public PasswordCredential(@lombok.NonNull String resource, @lombok.NonNull String userName, @lombok.NonNull char[] password) {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.resource = resource;
            this.userName = userName;
            this.password = password;
        }

        @lombok.NonNull
        @Generated
        public String getResource() {
            return this.resource;
        }

        @lombok.NonNull
        @Generated
        public String getUserName() {
            return this.userName;
        }

        @lombok.NonNull
        @Generated
        public char[] getPassword() {
            return this.password;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PasswordCredential)) {
                return false;
            }
            PasswordCredential other = (PasswordCredential)o;
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            return Arrays.equals(this.getPassword(), other.getPassword());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            result = result * 59 + Arrays.hashCode(this.getPassword());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "WinPasswordVault.PasswordCredential(resource=" + this.getResource() + ", userName=" + this.getUserName() + ", password=" + Arrays.toString(this.getPassword()) + ")";
        }
    }
}

