/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.web;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.DataCursor;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.util.web.DataRequest;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;

public interface SdmxWebClient {
    public @NonNull String getName() throws IOException;

    public @NonNull List<Dataflow> getFlows() throws IOException;

    public @NonNull Dataflow getFlow(@NonNull DataflowRef var1) throws IOException;

    public @NonNull DataStructure getStructure(@NonNull DataStructureRef var1) throws IOException;

    public @NonNull DataCursor getData(@NonNull DataRequest var1, @NonNull DataStructure var2) throws IOException;

    public boolean isDetailSupported() throws IOException;

    public @Nullable DataStructureRef peekStructureRef(@NonNull DataflowRef var1) throws IOException;

    public @NonNull Duration ping() throws IOException;

    public static @NonNull String getClientName(@NonNull SdmxWebSource source) {
        return source.getDriver() + ":" + source.getName();
    }

    @FunctionalInterface
    public static interface Supplier {
        public @NonNull SdmxWebClient get(@NonNull SdmxWebSource var1, @NonNull SdmxWebContext var2) throws IOException;
    }
}

