/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.web;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;
import sdmxdl.DataCursor;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.SdmxCache;
import sdmxdl.repo.DataSet;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.util.TypedId;
import sdmxdl.util.web.DataRequest;
import sdmxdl.util.web.SdmxWebClient;
import sdmxdl.web.SdmxWebSource;

final class CachedWebClient
implements SdmxWebClient {
    @NonNull
    private final SdmxWebClient delegate;
    @NonNull
    private final SdmxCache cache;
    @NonNull
    private final String base;
    @NonNull
    private final Duration ttl;
    private final AtomicReference<Object> idOfFlows = new AtomicReference();
    private final AtomicReference<Object> idOfFlow = new AtomicReference();
    private final AtomicReference<Object> idOfStruct = new AtomicReference();
    private final AtomicReference<Object> idOfSeriesKeysOnly = new AtomicReference();
    private final AtomicReference<Object> idOfNoData = new AtomicReference();

    static @org.checkerframework.checker.nullness.qual.NonNull SdmxWebClient of(@org.checkerframework.checker.nullness.qual.NonNull SdmxWebClient client, @org.checkerframework.checker.nullness.qual.NonNull SdmxCache cache, long ttlInMillis, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList languages) {
        return new CachedWebClient(client, cache, CachedWebClient.getBase(source, languages), Duration.ofMillis(ttlInMillis));
    }

    private static String getBase(SdmxWebSource source, LanguagePriorityList languages) {
        return source.getEndpoint().getHost() + languages.toString() + "/";
    }

    private static TypedId<List<Dataflow>> initIdOfFlows(String base) {
        return TypedId.of("flows://" + base, SdmxRepository::getFlows, flows -> SdmxRepository.builder().flows((Collection)flows).build());
    }

    private static TypedId<Dataflow> initIdOfFlow(String base) {
        return TypedId.of("flow://" + base, repo -> repo.getFlows().stream().findFirst().orElse(null), flow -> SdmxRepository.builder().flow(flow).build());
    }

    private static TypedId<DataStructure> initIdOfStruct(String base) {
        return TypedId.of("struct://" + base, repo -> repo.getStructures().stream().findFirst().orElse(null), struct -> SdmxRepository.builder().structure(struct).build());
    }

    private static TypedId<DataSet> initIdOfSeriesKeysOnly(String base) {
        return TypedId.of("seriesKeysOnly://" + base, repo -> repo.getDataSets().stream().findFirst().orElse(null), dataSet -> SdmxRepository.builder().dataSet(dataSet).build());
    }

    private static TypedId<DataSet> initIdOfNoData(String base) {
        return TypedId.of("noData://" + base, repo -> repo.getDataSets().stream().findFirst().orElse(null), dataSet -> SdmxRepository.builder().dataSet(dataSet).build());
    }

    @Override
    public String getName() throws IOException {
        return this.delegate.getName();
    }

    @Override
    public List<Dataflow> getFlows() throws IOException {
        return this.loadDataflowsWithCache();
    }

    @Override
    public Dataflow getFlow(DataflowRef ref) throws IOException {
        Dataflow result = this.peekDataflowFromCache(ref);
        return result != null ? result : this.loadDataflowWithCache(ref);
    }

    @Override
    public DataStructure getStructure(DataStructureRef ref) throws IOException {
        return this.loadDataStructureWithCache(ref);
    }

    @Override
    public DataCursor getData(DataRequest request, DataStructure dsd) throws IOException {
        if (request.getFilter().getDetail().isDataRequested()) {
            return this.delegate.getData(request, dsd);
        }
        DataSet result = request.getFilter().getDetail().isMetaRequested() ? this.loadNoDataWithCache(request, dsd) : this.loadSeriesKeysOnlyWithCache(request, dsd);
        return result.getDataCursor(request.getKey(), request.getFilter());
    }

    @Override
    public boolean isDetailSupported() throws IOException {
        return this.delegate.isDetailSupported();
    }

    @Override
    public DataStructureRef peekStructureRef(DataflowRef flowRef) throws IOException {
        return this.delegate.peekStructureRef(flowRef);
    }

    @Override
    public Duration ping() throws IOException {
        return this.delegate.ping();
    }

    private List<Dataflow> loadDataflowsWithCache() throws IOException {
        return this.getIdOfFlows().load(this.cache, (IOSupplier<List<Dataflow>>)((IOSupplier)this.delegate::getFlows), this::getTtl);
    }

    private DataStructure loadDataStructureWithCache(DataStructureRef ref) throws IOException {
        TypedId<DataStructure> id = this.getIdOfStruct().with(ref);
        return id.load(this.cache, (IOSupplier<DataStructure>)((IOSupplier)() -> this.delegate.getStructure(ref)), this::getTtl);
    }

    private DataSet loadSeriesKeysOnlyWithCache(DataRequest request, DataStructure dsd) throws IOException {
        TypedId<DataSet> id = this.getIdOfSeriesKeysOnly().with(request.getFlowRef());
        return id.load(this.cache, (IOSupplier<DataSet>)((IOSupplier)() -> this.copyData(request, dsd)), this::getTtl, o -> this.isNarrowerRequest(request.getKey(), (DataSet)o));
    }

    private DataSet loadNoDataWithCache(DataRequest request, DataStructure dsd) throws IOException {
        TypedId<DataSet> id = this.getIdOfNoData().with(request.getFlowRef());
        return id.load(this.cache, (IOSupplier<DataSet>)((IOSupplier)() -> this.copyData(request, dsd)), this::getTtl, o -> this.isNarrowerRequest(request.getKey(), (DataSet)o));
    }

    private Dataflow peekDataflowFromCache(DataflowRef ref) {
        List<Dataflow> dataFlows = this.getIdOfFlows().peek(this.cache);
        if (dataFlows == null) {
            return null;
        }
        for (Dataflow o : dataFlows) {
            if (!o.getRef().getId().equals(ref.getId())) continue;
            return o;
        }
        return null;
    }

    private Dataflow loadDataflowWithCache(DataflowRef ref) throws IOException {
        TypedId<Dataflow> id = this.getIdOfFlow().with(ref);
        return id.load(this.cache, (IOSupplier<Dataflow>)((IOSupplier)() -> this.delegate.getFlow(ref)), this::getTtl);
    }

    private boolean isNarrowerRequest(Key key, DataSet dataSet) {
        return !key.supersedes(dataSet.getKey()) && dataSet.getKey().contains(key);
    }

    private DataSet copyData(DataRequest request, DataStructure structure) throws IOException {
        try (DataCursor cursor = this.delegate.getData(request, structure);){
            DataSet dataSet = DataSet.builder().ref(request.getFlowRef()).key(request.getKey()).copyOf(cursor).build();
            return dataSet;
        }
    }

    private Duration getTtl(Object o) {
        return this.ttl;
    }

    @Generated
    public CachedWebClient(@NonNull SdmxWebClient delegate, @NonNull SdmxCache cache, @NonNull String base, @NonNull Duration ttl) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (ttl == null) {
            throw new NullPointerException("ttl is marked non-null but is null");
        }
        this.delegate = delegate;
        this.cache = cache;
        this.base = base;
        this.ttl = ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<List<Dataflow>> getIdOfFlows() {
        Object value = this.idOfFlows.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfFlows;
            synchronized (atomicReference) {
                value = this.idOfFlows.get();
                if (value == null) {
                    TypedId<List<Dataflow>> actualValue = CachedWebClient.initIdOfFlows(this.base);
                    value = actualValue == null ? this.idOfFlows : actualValue;
                    this.idOfFlows.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfFlows ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<Dataflow> getIdOfFlow() {
        Object value = this.idOfFlow.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfFlow;
            synchronized (atomicReference) {
                value = this.idOfFlow.get();
                if (value == null) {
                    TypedId<Dataflow> actualValue = CachedWebClient.initIdOfFlow(this.base);
                    value = actualValue == null ? this.idOfFlow : actualValue;
                    this.idOfFlow.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfFlow ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<DataStructure> getIdOfStruct() {
        Object value = this.idOfStruct.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfStruct;
            synchronized (atomicReference) {
                value = this.idOfStruct.get();
                if (value == null) {
                    TypedId<DataStructure> actualValue = CachedWebClient.initIdOfStruct(this.base);
                    value = actualValue == null ? this.idOfStruct : actualValue;
                    this.idOfStruct.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfStruct ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<DataSet> getIdOfSeriesKeysOnly() {
        Object value = this.idOfSeriesKeysOnly.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfSeriesKeysOnly;
            synchronized (atomicReference) {
                value = this.idOfSeriesKeysOnly.get();
                if (value == null) {
                    TypedId<DataSet> actualValue = CachedWebClient.initIdOfSeriesKeysOnly(this.base);
                    value = actualValue == null ? this.idOfSeriesKeysOnly : actualValue;
                    this.idOfSeriesKeysOnly.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfSeriesKeysOnly ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public TypedId<DataSet> getIdOfNoData() {
        Object value = this.idOfNoData.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idOfNoData;
            synchronized (atomicReference) {
                value = this.idOfNoData.get();
                if (value == null) {
                    TypedId<DataSet> actualValue = CachedWebClient.initIdOfNoData(this.base);
                    value = actualValue == null ? this.idOfNoData : actualValue;
                    this.idOfNoData.set(value);
                }
            }
        }
        return (TypedId)(value == this.idOfNoData ? null : value);
    }
}

