/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.parser;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.Frequency;

public final class PeriodParsers {
    private static final Parser<LocalDateTime> YEAR_MONTH = PeriodParsers.onDatePattern("yyyy-MM");
    private static final Parser<LocalDateTime> YEAR_MONTH_DAY = PeriodParsers.onDatePattern("yyyy-MM-dd");
    private static final Parser<LocalDateTime> ANNUAL = PeriodParsers.onDatePattern("yyyy").orElse(PeriodParsers.onDatePattern("yyyy'-01'")).orElse(PeriodParsers.onDatePattern("yyyy'-A1'"));
    private static final Parser<LocalDateTime> HALF_YEARLY = PeriodParsers.onYearFreqPos("S", 2).orElse(YEAR_MONTH);
    private static final Parser<LocalDateTime> QUARTERLY = PeriodParsers.onYearFreqPos("Q", 4).orElse(YEAR_MONTH);
    private static final Parser<LocalDateTime> MONTHLY = PeriodParsers.onYearFreqPos("M", 12).orElse(YEAR_MONTH);
    private static final Parser<LocalDateTime> WEEKLY = YEAR_MONTH_DAY;
    private static final Parser<LocalDateTime> DAILY = YEAR_MONTH_DAY;
    private static final Parser<LocalDateTime> HOURLY = YEAR_MONTH_DAY;
    private static final Parser<LocalDateTime> DAILY_BUSINESS = YEAR_MONTH_DAY;
    private static final Parser<LocalDateTime> MINUTELY = YEAR_MONTH_DAY;
    private static final Parser<LocalDateTime> UNDEFINED = YEAR_MONTH;

    public static @NonNull Parser<LocalDateTime> onStandardFreq(@NonNull Frequency freq) {
        switch (freq) {
            case ANNUAL: {
                return ANNUAL;
            }
            case HALF_YEARLY: {
                return HALF_YEARLY;
            }
            case QUARTERLY: {
                return QUARTERLY;
            }
            case MONTHLY: {
                return MONTHLY;
            }
            case WEEKLY: {
                return WEEKLY;
            }
            case DAILY: {
                return DAILY;
            }
            case HOURLY: {
                return HOURLY;
            }
            case DAILY_BUSINESS: {
                return DAILY_BUSINESS;
            }
            case MINUTELY: {
                return MINUTELY;
            }
            case UNDEFINED: {
                return UNDEFINED;
            }
        }
        throw new RuntimeException();
    }

    public static @NonNull Parser<LocalDateTime> onDatePattern(@NonNull String pattern) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(pattern).parseStrict().parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT);
        return Parser.onDateTimeFormatter((DateTimeFormatter)formatter, (TemporalQuery[])new TemporalQuery[]{LocalDateTime::from});
    }

    public static @NonNull Parser<LocalDateTime> onYearFreqPos(@NonNull String freqCode, @NonNegative int freq) {
        return new YearFreqPos(freqCode, freq);
    }

    @Generated
    private PeriodParsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class YearFreqPos
    implements Parser<LocalDateTime> {
        private final Pattern regex;
        private final int freq;

        public YearFreqPos(String freqCode, int freq) {
            this.regex = Pattern.compile("(\\d+)-?" + freqCode + "(\\d+)");
            this.freq = freq;
        }

        public LocalDateTime parse(CharSequence input) {
            if (input == null) {
                return null;
            }
            Matcher m = this.regex.matcher(input);
            return m.matches() ? this.toDate(Integer.parseInt(m.group(1)), this.freq, Integer.parseInt(m.group(2)) - 1) : null;
        }

        private LocalDateTime toDate(int year, int freq, int pos) {
            return pos < 0 || pos >= freq ? null : LocalDate.of(year, pos * (12 / freq) + 1, 1).atStartOfDay();
        }
    }
}

