/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.parser;

import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.Frequency;

public final class FreqParsers {
    public static @NonNull Parser<Frequency> onFreqCodeList() {
        return FreqParsers::parseFreqCode;
    }

    public static @NonNull Parser<Frequency> onTimeFormatCodeList() {
        return FreqParsers::parseTimeFormatCode;
    }

    @VisibleForTesting
    static Frequency parseFreqCode(CharSequence code) {
        if (code == null) {
            return null;
        }
        switch (code.length()) {
            case 0: {
                return null;
            }
            case 1: {
                return FreqParsers.parseStandardFreqCode(code.charAt(0));
            }
        }
        Frequency base = FreqParsers.parseStandardFreqCode(code.charAt(0));
        return FreqParsers.isMultiplier(code.toString().substring(1)) ? base : null;
    }

    private static Frequency parseStandardFreqCode(char code) {
        switch (code) {
            case 'A': {
                return Frequency.ANNUAL;
            }
            case 'S': {
                return Frequency.HALF_YEARLY;
            }
            case 'Q': {
                return Frequency.QUARTERLY;
            }
            case 'M': {
                return Frequency.MONTHLY;
            }
            case 'W': {
                return Frequency.WEEKLY;
            }
            case 'D': {
                return Frequency.DAILY;
            }
            case 'H': {
                return Frequency.HOURLY;
            }
            case 'B': {
                return Frequency.DAILY_BUSINESS;
            }
            case 'N': {
                return Frequency.MINUTELY;
            }
        }
        return null;
    }

    private static boolean isMultiplier(String input) {
        try {
            return Integer.parseInt(input) > 1;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @VisibleForTesting
    static Frequency parseTimeFormatCode(CharSequence code) {
        if (code == null) {
            return null;
        }
        switch (code.toString()) {
            case "P1Y": {
                return Frequency.ANNUAL;
            }
            case "P6M": {
                return Frequency.HALF_YEARLY;
            }
            case "P3M": {
                return Frequency.QUARTERLY;
            }
            case "P1M": {
                return Frequency.MONTHLY;
            }
            case "P7D": {
                return Frequency.WEEKLY;
            }
            case "P1D": {
                return Frequency.DAILY;
            }
            case "PT1M": {
                return Frequency.MINUTELY;
            }
        }
        return null;
    }

    @Generated
    private FreqParsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

