/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.parser;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Frequency;
import sdmxdl.Key;
import sdmxdl.ext.ObsParser;

public final class DefaultObsParser
implements ObsParser {
    private final BiFunction<Key.Builder, UnaryOperator<String>, Frequency> freqFactory;
    private final Function<Frequency, Parser<LocalDateTime>> periodFactory;
    private final Parser<Double> valueParser;
    private Parser<LocalDateTime> periodParser = Parser.onNull();
    private Frequency freq = Frequency.UNDEFINED;
    private String period = null;
    private String value = null;

    public @NonNull Frequency getFrequency() {
        return this.freq;
    }

    public @Nullable String getPeriod() {
        return this.period;
    }

    public @Nullable String getValue() {
        return this.value;
    }

    public @NonNull ObsParser clear() {
        this.period = null;
        this.value = null;
        return this;
    }

    public @NonNull ObsParser frequency(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Key.Builder key, @NonNull UnaryOperator<String> attributes) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(attributes);
        Frequency freq = this.freqFactory.apply(key, attributes);
        if (this.freq != freq) {
            this.freq = freq;
            this.periodParser = this.periodFactory.apply(freq);
            if (this.periodParser == null) {
                this.periodParser = Parser.onNull();
            }
        }
        return this;
    }

    public @NonNull ObsParser period(@Nullable String period) {
        this.period = period;
        return this;
    }

    public @NonNull ObsParser value(@Nullable String value) {
        this.value = value;
        return this;
    }

    public @Nullable LocalDateTime parsePeriod() {
        return (LocalDateTime)this.periodParser.parse((CharSequence)this.period);
    }

    public @Nullable Double parseValue() {
        return (Double)this.valueParser.parse((CharSequence)this.value);
    }

    @Generated
    public DefaultObsParser(BiFunction<Key.Builder, UnaryOperator<String>, Frequency> freqFactory, Function<Frequency, Parser<LocalDateTime>> periodFactory, Parser<Double> valueParser) {
        this.freqFactory = freqFactory;
        this.periodFactory = periodFactory;
        this.valueParser = valueParser;
    }
}

