/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.file;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IORunnable;
import sdmxdl.DataCursor;
import sdmxdl.DataFilter;
import sdmxdl.DataStructure;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.ResourceRef;
import sdmxdl.Series;
import sdmxdl.ext.SdmxException;
import sdmxdl.file.SdmxFileConnection;
import sdmxdl.util.file.SdmxFileClient;
import sdmxdl.util.file.SdmxFileInfo;

public final class SdmxFileConnectionImpl
implements SdmxFileConnection {
    @NonNull
    private final SdmxFileClient client;
    @NonNull
    private final Dataflow dataflow;
    private boolean closed = false;

    public DataflowRef getDataflowRef() throws IOException {
        this.checkState();
        return this.dataflow.getRef();
    }

    public Collection<Dataflow> getFlows() throws IOException {
        this.checkState();
        return Collections.singleton(this.dataflow);
    }

    public Dataflow getFlow() throws IOException {
        this.checkState();
        return this.dataflow;
    }

    public Dataflow getFlow(DataflowRef flowRef) throws IOException {
        this.checkState();
        this.checkFlowRef(flowRef);
        return this.dataflow;
    }

    public DataStructure getStructure() throws IOException {
        this.checkState();
        return this.client.decode().getStructure();
    }

    public DataStructure getStructure(DataflowRef flowRef) throws IOException {
        this.checkState();
        this.checkFlowRef(flowRef);
        return this.client.decode().getStructure();
    }

    public List<Series> getData(Key key, DataFilter filter) throws IOException {
        try (DataCursor cursor = this.getDataCursor(key, filter);){
            List<Series> list = cursor.toStream().collect(Collectors.toList());
            return list;
        }
    }

    public List<Series> getData(DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        try (DataCursor cursor = this.getDataCursor(flowRef, key, filter);){
            List<Series> list = cursor.toStream().collect(Collectors.toList());
            return list;
        }
    }

    public Stream<Series> getDataStream(Key key, DataFilter filter) throws IOException {
        DataCursor cursor = this.getDataCursor(key, filter);
        return (Stream)cursor.toStream().onClose(IORunnable.unchecked(() -> cursor.close()));
    }

    public Stream<Series> getDataStream(DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        DataCursor cursor = this.getDataCursor(flowRef, key, filter);
        return (Stream)cursor.toStream().onClose(IORunnable.unchecked(() -> cursor.close()));
    }

    public DataCursor getDataCursor(Key key, DataFilter filter) throws IOException {
        this.checkState();
        Objects.requireNonNull(key);
        Objects.requireNonNull(filter);
        SdmxFileInfo info = this.client.decode();
        this.checkKey(key, info);
        return this.client.loadData(info, this.dataflow.getRef(), key, filter);
    }

    public DataCursor getDataCursor(DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        this.checkState();
        this.checkFlowRef(flowRef);
        Objects.requireNonNull(key);
        Objects.requireNonNull(filter);
        SdmxFileInfo info = this.client.decode();
        this.checkKey(key, info);
        return this.client.loadData(info, this.dataflow.getRef(), key, filter);
    }

    public boolean isDetailSupported() {
        return true;
    }

    public void close() {
        this.closed = true;
    }

    private String getName() {
        return "fixme";
    }

    private void checkState() throws IOException {
        if (this.closed) {
            throw SdmxException.connectionClosed((String)this.getName());
        }
    }

    private void checkKey(Key key, SdmxFileInfo info) throws IOException {
        String msg = key.validateOn(info.getStructure());
        if (msg != null) {
            throw SdmxException.invalidKey((String)this.getName(), (Key)key, (String)msg);
        }
    }

    private void checkFlowRef(DataflowRef flowRef) throws IOException {
        Objects.requireNonNull(flowRef);
        if (!this.dataflow.getRef().contains((ResourceRef)flowRef)) {
            throw SdmxException.missingFlow((String)this.getName(), (DataflowRef)flowRef);
        }
    }

    @Generated
    public SdmxFileConnectionImpl(@NonNull SdmxFileClient client, @NonNull Dataflow dataflow) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (dataflow == null) {
            throw new NullPointerException("dataflow is marked non-null but is null");
        }
        this.client = client;
        this.dataflow = dataflow;
    }
}

