/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.ext.SdmxCache;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.web.SdmxWebMonitorReports;

public final class MapCache
implements SdmxCache {
    @lombok.NonNull
    private final ConcurrentMap<String, SdmxRepository> repositories;
    @lombok.NonNull
    private final ConcurrentMap<String, SdmxWebMonitorReports> webMonitors;
    @lombok.NonNull
    private final Clock clock;

    public static @NonNull MapCache of() {
        return MapCache.of(new ConcurrentHashMap<String, SdmxRepository>(), new ConcurrentHashMap<String, SdmxWebMonitorReports>(), Clock.systemDefaultZone());
    }

    public @Nullable SdmxRepository getRepository(@NonNull String key) {
        Objects.requireNonNull(key);
        return MapCache.getRepository(this.repositories, this.clock, key);
    }

    public void putRepository(@NonNull String key, @NonNull SdmxRepository value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        MapCache.put(this.repositories, key, value);
    }

    public @Nullable SdmxWebMonitorReports getWebMonitorReports(@NonNull String key) {
        Objects.requireNonNull(key);
        return MapCache.getWebMonitorReports(this.webMonitors, this.clock, key);
    }

    public void putWebMonitorReports(@NonNull String key, @NonNull SdmxWebMonitorReports value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        MapCache.put(this.webMonitors, key, value);
    }

    @VisibleForTesting
    static SdmxRepository getRepository(@NonNull ConcurrentMap<String, SdmxRepository> map, @NonNull Clock clock, @NonNull String key) {
        return MapCache.get(reports -> !reports.isExpired(clock), map, key);
    }

    @VisibleForTesting
    static SdmxWebMonitorReports getWebMonitorReports(@NonNull ConcurrentMap<String, SdmxWebMonitorReports> map, @NonNull Clock clock, @NonNull String key) {
        return MapCache.get(reports -> !reports.isExpired(clock), map, key);
    }

    private static <T> @Nullable T get(@NonNull Predicate<T> validator, @NonNull ConcurrentMap<String, T> map, @NonNull String key) {
        Object result = map.get(key);
        if (result == null) {
            return null;
        }
        if (!validator.test(result)) {
            map.remove(key);
            return null;
        }
        return (T)result;
    }

    @VisibleForTesting
    static <T> void put(@NonNull ConcurrentMap<String, T> map, @NonNull String key, @NonNull T value) {
        Objects.requireNonNull(value);
        map.put(key, value);
    }

    @lombok.NonNull
    @Generated
    public ConcurrentMap<String, SdmxRepository> getRepositories() {
        return this.repositories;
    }

    @lombok.NonNull
    @Generated
    public ConcurrentMap<String, SdmxWebMonitorReports> getWebMonitors() {
        return this.webMonitors;
    }

    @lombok.NonNull
    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    private MapCache(@lombok.NonNull ConcurrentMap<String, SdmxRepository> repositories, @lombok.NonNull ConcurrentMap<String, SdmxWebMonitorReports> webMonitors, @lombok.NonNull Clock clock) {
        if (repositories == null) {
            throw new NullPointerException("repositories is marked non-null but is null");
        }
        if (webMonitors == null) {
            throw new NullPointerException("webMonitors is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.repositories = repositories;
        this.webMonitors = webMonitors;
        this.clock = clock;
    }

    @Generated
    public static @NonNull MapCache of(@lombok.NonNull ConcurrentMap<String, SdmxRepository> repositories, @lombok.NonNull ConcurrentMap<String, SdmxWebMonitorReports> webMonitors, @lombok.NonNull Clock clock) {
        return new MapCache(repositories, webMonitors, clock);
    }
}

