/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import nbbrd.io.FileFormatter;
import nbbrd.io.FileParser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FileFormat<T> {
    @lombok.NonNull
    private final FileParser<T> parser;
    @lombok.NonNull
    private final FileFormatter<T> formatter;
    @lombok.NonNull
    private final String fileExtension;

    public static <T, F extends FileParser<T> & FileFormatter<T>> @NonNull FileFormat<T> of(@NonNull F fileFormat, @NonNull String fileExtension) {
        return new FileFormat<T>(fileFormat, fileFormat, fileExtension);
    }

    public static <T> @NonNull FileFormat<T> noOp() {
        return new FileFormat<T>(FileFormat.noOpParser(), FileFormat.noOpFormatter(), "");
    }

    public static <T> @NonNull FileFormat<T> gzip(@NonNull FileFormat<T> delegate) {
        return new FileFormat<T>(FileFormat.gzipParser(delegate.getParser()), FileFormat.gzipFormatter(delegate.getFormatter()), delegate.getFileExtension() + ".gz");
    }

    private static <T> @NonNull FileParser<T> noOpParser() {
        return resource -> {
            throw new IOException("Cannot parse stream");
        };
    }

    private static <T> @NonNull FileFormatter<T> noOpFormatter() {
        return (value, resource) -> {
            throw new IOException("Cannot format stream");
        };
    }

    private static <T> @NonNull FileParser<T> gzipParser(@NonNull FileParser<T> delegate) {
        return resource -> {
            try (GZIPInputStream gzip = new GZIPInputStream(resource);){
                Object object = delegate.parseStream((InputStream)gzip);
                return object;
            }
        };
    }

    private static <T> @NonNull FileFormatter<T> gzipFormatter(@NonNull FileFormatter<T> delegate) {
        return (value, resource) -> {
            try (GZIPOutputStream gzip = new GZIPOutputStream(resource);){
                delegate.formatStream(value, (OutputStream)gzip);
            }
        };
    }

    @Generated
    public FileFormat(@lombok.NonNull FileParser<T> parser, @lombok.NonNull FileFormatter<T> formatter, @lombok.NonNull String fileExtension) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (fileExtension == null) {
            throw new NullPointerException("fileExtension is marked non-null but is null");
        }
        this.parser = parser;
        this.formatter = formatter;
        this.fileExtension = fileExtension;
    }

    @lombok.NonNull
    @Generated
    public FileParser<T> getParser() {
        return this.parser;
    }

    @lombok.NonNull
    @Generated
    public FileFormatter<T> getFormatter() {
        return this.formatter;
    }

    @lombok.NonNull
    @Generated
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileFormat)) {
            return false;
        }
        FileFormat other = (FileFormat)o;
        FileParser<T> this$parser = this.getParser();
        FileParser<T> other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        FileFormatter<T> this$formatter = this.getFormatter();
        FileFormatter<T> other$formatter = other.getFormatter();
        if (this$formatter == null ? other$formatter != null : !this$formatter.equals(other$formatter)) {
            return false;
        }
        String this$fileExtension = this.getFileExtension();
        String other$fileExtension = other.getFileExtension();
        return !(this$fileExtension == null ? other$fileExtension != null : !this$fileExtension.equals(other$fileExtension));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileParser<T> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        FileFormatter<T> $formatter = this.getFormatter();
        result = result * 59 + ($formatter == null ? 43 : $formatter.hashCode());
        String $fileExtension = this.getFileExtension();
        result = result * 59 + ($fileExtension == null ? 43 : $fileExtension.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "FileFormat(parser=" + this.getParser() + ", formatter=" + this.getFormatter() + ", fileExtension=" + this.getFileExtension() + ")";
    }
}

