/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.ext;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.sys.SystemProperties;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.ext.SdmxCache;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.util.ext.FileFormat;
import sdmxdl.web.SdmxWebMonitorReports;

public final class FileCache
implements SdmxCache {
    @NonNull
    private final Path root;
    @NonNull
    private final String fileNamePrefix;
    @NonNull
    private final String fileNameSuffix;
    @NonNull
    private final UnaryOperator<String> fileNameGenerator;
    @NonNull
    private final FileFormat<SdmxRepository> repositoryFormat;
    @NonNull
    private final FileFormat<SdmxWebMonitorReports> monitorFormat;
    @NonNull
    private final BiConsumer<String, IOException> onIOException;
    @NonNull
    private final Clock clock;
    private static final UnaryOperator<String> DEFAULT_GENERATOR = key -> String.valueOf(Math.abs(key.hashCode()));
    private static final BiConsumer<String, IOException> DO_NOT_REPORT = (msg, ex) -> {};

    public @Nullable SdmxRepository getRepository(@org.checkerframework.checker.nullness.qual.NonNull String key) {
        Objects.requireNonNull(key);
        return this.read(this.repositoryFormat, this::isValid, key, FileType.REPOSITORY);
    }

    public void putRepository(@org.checkerframework.checker.nullness.qual.NonNull String key, @org.checkerframework.checker.nullness.qual.NonNull SdmxRepository value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.write(this.repositoryFormat, key, FileType.REPOSITORY, value);
    }

    public @Nullable SdmxWebMonitorReports getWebMonitorReports(@org.checkerframework.checker.nullness.qual.NonNull String key) {
        Objects.requireNonNull(key);
        return this.read(this.monitorFormat, this::isValid, key, FileType.MONITOR);
    }

    public void putWebMonitorReports(@org.checkerframework.checker.nullness.qual.NonNull String key, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebMonitorReports value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.write(this.monitorFormat, key, FileType.MONITOR, value);
    }

    private boolean isValid(SdmxRepository value) {
        return !value.isExpired(this.clock);
    }

    private boolean isValid(SdmxWebMonitorReports value) {
        return !value.isExpired(this.clock);
    }

    private <T> T read(FileFormat<T> fileFormat, Predicate<T> validator, String key, FileType fileType) {
        T result = this.read(fileFormat, fileType, key);
        if (result == null) {
            return null;
        }
        if (!validator.test(result)) {
            this.delete(key, fileType, fileFormat);
            return null;
        }
        return result;
    }

    private <T> T read(FileFormat<T> fileFormat, FileType fileType, String key) {
        Path file = this.getFile(key, fileType, fileFormat);
        if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            try {
                return (T)fileFormat.getParser().parsePath(file);
            }
            catch (IOException ex) {
                this.onIOException.accept("While reading '" + file + "'", ex);
            }
        }
        return null;
    }

    private <T> void write(FileFormat<T> fileFormat, String key, FileType fileType, T entry) {
        Path file = this.getFile(key, fileType, fileFormat);
        this.ensureParentExists(file);
        try {
            fileFormat.getFormatter().formatPath(entry, file);
        }
        catch (IOException ex) {
            this.onIOException.accept("While writing '" + file + "'", ex);
        }
    }

    private void ensureParentExists(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.onIOException.accept("While creating working dir '" + file + "'", ex);
        }
    }

    private void delete(String key, FileType fileType, FileFormat<?> fileFormat) {
        Path file = this.getFile(key, fileType, fileFormat);
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException ex) {
            this.onIOException.accept("While deleting '" + file + "'", ex);
        }
    }

    @VisibleForTesting
    Path getFile(String key, FileType fileType, FileFormat<?> fileFormat) {
        return this.root.resolve(this.fileNamePrefix + fileType.name().charAt(0) + (String)this.fileNameGenerator.apply(key) + this.fileNameSuffix + fileFormat.getFileExtension());
    }

    @Generated
    private static Path $default$root() {
        return SystemProperties.DEFAULT.getJavaIoTmpdir().resolve("sdmxdl");
    }

    @Generated
    private static String $default$fileNamePrefix() {
        return "sdmx_";
    }

    @Generated
    private static String $default$fileNameSuffix() {
        return "_";
    }

    @Generated
    private static UnaryOperator<String> $default$fileNameGenerator() {
        return DEFAULT_GENERATOR;
    }

    @Generated
    private static FileFormat<SdmxRepository> $default$repositoryFormat() {
        return FileFormat.noOp();
    }

    @Generated
    private static FileFormat<SdmxWebMonitorReports> $default$monitorFormat() {
        return FileFormat.noOp();
    }

    @Generated
    private static BiConsumer<String, IOException> $default$onIOException() {
        return DO_NOT_REPORT;
    }

    @Generated
    private static Clock $default$clock() {
        return Clock.systemDefaultZone();
    }

    @Generated
    FileCache(@NonNull Path root, @NonNull String fileNamePrefix, @NonNull String fileNameSuffix, @NonNull UnaryOperator<String> fileNameGenerator, @NonNull FileFormat<SdmxRepository> repositoryFormat, @NonNull FileFormat<SdmxWebMonitorReports> monitorFormat, @NonNull BiConsumer<String, IOException> onIOException, @NonNull Clock clock) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (fileNamePrefix == null) {
            throw new NullPointerException("fileNamePrefix is marked non-null but is null");
        }
        if (fileNameSuffix == null) {
            throw new NullPointerException("fileNameSuffix is marked non-null but is null");
        }
        if (fileNameGenerator == null) {
            throw new NullPointerException("fileNameGenerator is marked non-null but is null");
        }
        if (repositoryFormat == null) {
            throw new NullPointerException("repositoryFormat is marked non-null but is null");
        }
        if (monitorFormat == null) {
            throw new NullPointerException("monitorFormat is marked non-null but is null");
        }
        if (onIOException == null) {
            throw new NullPointerException("onIOException is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.root = root;
        this.fileNamePrefix = fileNamePrefix;
        this.fileNameSuffix = fileNameSuffix;
        this.fileNameGenerator = fileNameGenerator;
        this.repositoryFormat = repositoryFormat;
        this.monitorFormat = monitorFormat;
        this.onIOException = onIOException;
        this.clock = clock;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        return new Builder().root(this.root).fileNamePrefix(this.fileNamePrefix).fileNameSuffix(this.fileNameSuffix).fileNameGenerator(this.fileNameGenerator).repositoryFormat(this.repositoryFormat).monitorFormat(this.monitorFormat).onIOException(this.onIOException).clock(this.clock);
    }

    @NonNull
    @Generated
    public Path getRoot() {
        return this.root;
    }

    @NonNull
    @Generated
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @NonNull
    @Generated
    public String getFileNameSuffix() {
        return this.fileNameSuffix;
    }

    @NonNull
    @Generated
    public UnaryOperator<String> getFileNameGenerator() {
        return this.fileNameGenerator;
    }

    @NonNull
    @Generated
    public FileFormat<SdmxRepository> getRepositoryFormat() {
        return this.repositoryFormat;
    }

    @NonNull
    @Generated
    public FileFormat<SdmxWebMonitorReports> getMonitorFormat() {
        return this.monitorFormat;
    }

    @NonNull
    @Generated
    public BiConsumer<String, IOException> getOnIOException() {
        return this.onIOException;
    }

    @NonNull
    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean root$set;
        @Generated
        private Path root$value;
        @Generated
        private boolean fileNamePrefix$set;
        @Generated
        private String fileNamePrefix$value;
        @Generated
        private boolean fileNameSuffix$set;
        @Generated
        private String fileNameSuffix$value;
        @Generated
        private boolean fileNameGenerator$set;
        @Generated
        private UnaryOperator<String> fileNameGenerator$value;
        @Generated
        private boolean repositoryFormat$set;
        @Generated
        private FileFormat<SdmxRepository> repositoryFormat$value;
        @Generated
        private boolean monitorFormat$set;
        @Generated
        private FileFormat<SdmxWebMonitorReports> monitorFormat$value;
        @Generated
        private boolean onIOException$set;
        @Generated
        private BiConsumer<String, IOException> onIOException$value;
        @Generated
        private boolean clock$set;
        @Generated
        private Clock clock$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder root(@NonNull Path root) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            this.root$value = root;
            this.root$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fileNamePrefix(@NonNull String fileNamePrefix) {
            if (fileNamePrefix == null) {
                throw new NullPointerException("fileNamePrefix is marked non-null but is null");
            }
            this.fileNamePrefix$value = fileNamePrefix;
            this.fileNamePrefix$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fileNameSuffix(@NonNull String fileNameSuffix) {
            if (fileNameSuffix == null) {
                throw new NullPointerException("fileNameSuffix is marked non-null but is null");
            }
            this.fileNameSuffix$value = fileNameSuffix;
            this.fileNameSuffix$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder fileNameGenerator(@NonNull UnaryOperator<String> fileNameGenerator) {
            if (fileNameGenerator == null) {
                throw new NullPointerException("fileNameGenerator is marked non-null but is null");
            }
            this.fileNameGenerator$value = fileNameGenerator;
            this.fileNameGenerator$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder repositoryFormat(@NonNull FileFormat<SdmxRepository> repositoryFormat) {
            if (repositoryFormat == null) {
                throw new NullPointerException("repositoryFormat is marked non-null but is null");
            }
            this.repositoryFormat$value = repositoryFormat;
            this.repositoryFormat$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder monitorFormat(@NonNull FileFormat<SdmxWebMonitorReports> monitorFormat) {
            if (monitorFormat == null) {
                throw new NullPointerException("monitorFormat is marked non-null but is null");
            }
            this.monitorFormat$value = monitorFormat;
            this.monitorFormat$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder onIOException(@NonNull BiConsumer<String, IOException> onIOException) {
            if (onIOException == null) {
                throw new NullPointerException("onIOException is marked non-null but is null");
            }
            this.onIOException$value = onIOException;
            this.onIOException$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clock(@NonNull Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            this.clock$value = clock;
            this.clock$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull FileCache build() {
            Path root$value = this.root$value;
            if (!this.root$set) {
                root$value = FileCache.$default$root();
            }
            String fileNamePrefix$value = this.fileNamePrefix$value;
            if (!this.fileNamePrefix$set) {
                fileNamePrefix$value = FileCache.$default$fileNamePrefix();
            }
            String fileNameSuffix$value = this.fileNameSuffix$value;
            if (!this.fileNameSuffix$set) {
                fileNameSuffix$value = FileCache.$default$fileNameSuffix();
            }
            UnaryOperator fileNameGenerator$value = this.fileNameGenerator$value;
            if (!this.fileNameGenerator$set) {
                fileNameGenerator$value = FileCache.$default$fileNameGenerator();
            }
            FileFormat repositoryFormat$value = this.repositoryFormat$value;
            if (!this.repositoryFormat$set) {
                repositoryFormat$value = FileCache.$default$repositoryFormat();
            }
            FileFormat monitorFormat$value = this.monitorFormat$value;
            if (!this.monitorFormat$set) {
                monitorFormat$value = FileCache.$default$monitorFormat();
            }
            BiConsumer onIOException$value = this.onIOException$value;
            if (!this.onIOException$set) {
                onIOException$value = FileCache.$default$onIOException();
            }
            Clock clock$value = this.clock$value;
            if (!this.clock$set) {
                clock$value = FileCache.$default$clock();
            }
            return new FileCache(root$value, fileNamePrefix$value, fileNameSuffix$value, fileNameGenerator$value, repositoryFormat$value, monitorFormat$value, onIOException$value, clock$value);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "FileCache.Builder(root$value=" + this.root$value + ", fileNamePrefix$value=" + this.fileNamePrefix$value + ", fileNameSuffix$value=" + this.fileNameSuffix$value + ", fileNameGenerator$value=" + this.fileNameGenerator$value + ", repositoryFormat$value=" + this.repositoryFormat$value + ", monitorFormat$value=" + this.monitorFormat$value + ", onIOException$value=" + this.onIOException$value + ", clock$value=" + this.clock$value + ")";
        }
    }

    @VisibleForTesting
    static enum FileType {
        REPOSITORY,
        MONITOR;

    }
}

