/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.util.ext;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOFunction;
import nbbrd.io.text.Parser;
import nbbrd.io.xml.Stax;
import nbbrd.io.xml.Xml;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.util.web.SdmxWebEvents;
import sdmxdl.web.SdmxWebMonitor;
import sdmxdl.web.SdmxWebMonitorReport;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.SdmxWebStatus;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebMonitoring;

public final class UptimeRobot
implements SdmxWebMonitoring {
    private final URL url = (URL)Parser.onURL().parseValue((CharSequence)"https://api.uptimerobot.com/v2/getMonitors").orElseThrow(RuntimeException::new);
    private static final Parser<SdmxWebStatus> STATUS_PARSER = Parser.onEnum(Status.class, Status::getCode).andThen(Status::getReport);

    public String getProviderName() {
        return "UptimeRobot";
    }

    public SdmxWebMonitorReport getReport(SdmxWebSource source, SdmxWebContext context) throws IOException, IllegalArgumentException {
        this.checkMonitor(source.getMonitor());
        Query query = UptimeRobot.getQuery(source.getMonitor());
        Stax.StreamParser parser = Stax.StreamParser.valueOf(UptimeRobot::parseReport);
        return (SdmxWebMonitorReport)UptimeRobot.post(this.url, query.toBody(), arg_0 -> ((Xml.Parser)parser).parseReader(arg_0), context, source);
    }

    private void checkMonitor(SdmxWebMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("Expecting monitor not to be null");
        }
        if (!monitor.getProvider().equals(this.getProviderName())) {
            throw new IllegalArgumentException(monitor.toString());
        }
    }

    private static Query getQuery(SdmxWebMonitor monitor) {
        return Query.builder().apiKey(monitor.getId()).allTimeUptimeRatio(true).responseTimesAverage(false).build();
    }

    private static SdmxWebMonitorReport parseReport(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals("monitor")) break;
                    return SdmxWebMonitorReport.builder().source(reader.getAttributeValue(null, "friendly_name")).status((SdmxWebStatus)STATUS_PARSER.parseValue((CharSequence)reader.getAttributeValue(null, "status")).orElseThrow(() -> new XMLStreamException("Cannot parse status"))).uptimeRatio((Double)Parser.onDouble().parse((CharSequence)reader.getAttributeValue(null, "all_time_uptime_ratio"))).averageResponseTime((Long)Parser.onLong().parse((CharSequence)reader.getAttributeValue(null, "average_response_time"))).build();
                }
            }
        }
        throw new RuntimeException("Not found");
    }

    private static URI toURI(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private static <T> T post(URL url, String query, IOFunction<Reader, T> factory, SdmxWebContext context, SdmxWebSource source) throws IOException {
        HttpURLConnection conn;
        byte[] data = query.getBytes(StandardCharsets.UTF_8);
        Proxy proxy = context.getProxySelector().select(UptimeRobot.toURI(url)).stream().findFirst().orElse(Proxy.NO_PROXY);
        if (context.getEventListener().isEnabled()) {
            context.getEventListener().onWebSourceEvent(source, SdmxWebEvents.onQuery(url, proxy));
        }
        if ((conn = (HttpURLConnection)url.openConnection(proxy)) instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(context.getSslSocketFactory());
            ((HttpsURLConnection)conn).setHostnameVerifier(context.getHostnameVerifier());
        }
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("cache-control", "no-cache");
        conn.setRequestProperty("charset", "utf-8");
        conn.setRequestProperty("Content-Length", Integer.toString(data.length));
        conn.setUseCaches(false);
        try (OutputStream wr = conn.getOutputStream();){
            wr.write(data);
        }
        try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
            Object object = factory.applyWithIO((Object)reader);
            return (T)object;
        }
    }

    private static enum Status {
        PAUSED(0, SdmxWebStatus.UNKNOWN),
        NOT_CHECKED_YET(1, SdmxWebStatus.UNKNOWN),
        UP(2, SdmxWebStatus.UP),
        SEEMS_DOWN(8, SdmxWebStatus.DOWN),
        DOWN(9, SdmxWebStatus.DOWN);

        int code;
        SdmxWebStatus report;

        @Generated
        private Status(int code, SdmxWebStatus report) {
            this.code = code;
            this.report = report;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public SdmxWebStatus getReport() {
            return this.report;
        }
    }

    private static final class Query {
        @NonNull
        private final String apiKey;
        private final boolean logs;
        private final boolean allTimeUptimeRatio;
        private final boolean responseTimesAverage;

        public @org.checkerframework.checker.nullness.qual.NonNull String toBody() {
            return "api_key=" + this.apiKey + "&format=xml&logs=" + this.format(this.logs) + "&all_time_uptime_ratio=" + this.format(this.allTimeUptimeRatio) + "&response_times_average=" + this.format(this.responseTimesAverage);
        }

        private String format(boolean value) {
            return value ? "1" : "0";
        }

        @Generated
        private static boolean $default$logs() {
            return false;
        }

        @Generated
        private static boolean $default$allTimeUptimeRatio() {
            return false;
        }

        @Generated
        private static boolean $default$responseTimesAverage() {
            return false;
        }

        @Generated
        Query(@NonNull String apiKey, boolean logs, boolean allTimeUptimeRatio, boolean responseTimesAverage) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            this.logs = logs;
            this.allTimeUptimeRatio = allTimeUptimeRatio;
            this.responseTimesAverage = responseTimesAverage;
        }

        @Generated
        public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
            return new Builder();
        }

        @NonNull
        @Generated
        public String getApiKey() {
            return this.apiKey;
        }

        @Generated
        public boolean isLogs() {
            return this.logs;
        }

        @Generated
        public boolean isAllTimeUptimeRatio() {
            return this.allTimeUptimeRatio;
        }

        @Generated
        public boolean isResponseTimesAverage() {
            return this.responseTimesAverage;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            if (this.isLogs() != other.isLogs()) {
                return false;
            }
            if (this.isAllTimeUptimeRatio() != other.isAllTimeUptimeRatio()) {
                return false;
            }
            if (this.isResponseTimesAverage() != other.isResponseTimesAverage()) {
                return false;
            }
            String this$apiKey = this.getApiKey();
            String other$apiKey = other.getApiKey();
            return !(this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLogs() ? 79 : 97);
            result = result * 59 + (this.isAllTimeUptimeRatio() ? 79 : 97);
            result = result * 59 + (this.isResponseTimesAverage() ? 79 : 97);
            String $apiKey = this.getApiKey();
            result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "UptimeRobot.Query(apiKey=" + this.getApiKey() + ", logs=" + this.isLogs() + ", allTimeUptimeRatio=" + this.isAllTimeUptimeRatio() + ", responseTimesAverage=" + this.isResponseTimesAverage() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private String apiKey;
            @Generated
            private boolean logs$set;
            @Generated
            private boolean logs$value;
            @Generated
            private boolean allTimeUptimeRatio$set;
            @Generated
            private boolean allTimeUptimeRatio$value;
            @Generated
            private boolean responseTimesAverage$set;
            @Generated
            private boolean responseTimesAverage$value;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder apiKey(@NonNull String apiKey) {
                if (apiKey == null) {
                    throw new NullPointerException("apiKey is marked non-null but is null");
                }
                this.apiKey = apiKey;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder logs(boolean logs) {
                this.logs$value = logs;
                this.logs$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder allTimeUptimeRatio(boolean allTimeUptimeRatio) {
                this.allTimeUptimeRatio$value = allTimeUptimeRatio;
                this.allTimeUptimeRatio$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder responseTimesAverage(boolean responseTimesAverage) {
                this.responseTimesAverage$value = responseTimesAverage;
                this.responseTimesAverage$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Query build() {
                boolean logs$value = this.logs$value;
                if (!this.logs$set) {
                    logs$value = Query.$default$logs();
                }
                boolean allTimeUptimeRatio$value = this.allTimeUptimeRatio$value;
                if (!this.allTimeUptimeRatio$set) {
                    allTimeUptimeRatio$value = Query.$default$allTimeUptimeRatio();
                }
                boolean responseTimesAverage$value = this.responseTimesAverage$value;
                if (!this.responseTimesAverage$set) {
                    responseTimesAverage$value = Query.$default$responseTimesAverage();
                }
                return new Query(this.apiKey, logs$value, allTimeUptimeRatio$value, responseTimesAverage$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "UptimeRobot.Query.Builder(apiKey=" + this.apiKey + ", logs$value=" + this.logs$value + ", allTimeUptimeRatio$value=" + this.allTimeUptimeRatio$value + ", responseTimesAverage$value=" + this.responseTimesAverage$value + ")";
            }
        }
    }
}

