/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http.ext;

import internal.util.http.HttpClient;
import internal.util.http.HttpRequest;
import internal.util.http.HttpResponse;
import java.io.Closeable;
import java.io.IOException;
import lombok.Generated;
import nbbrd.io.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class InterceptingClient
implements HttpClient {
    @lombok.NonNull
    private final HttpClient delegate;
    @lombok.NonNull
    private final Interceptor interceptor;

    @Override
    public @NonNull HttpResponse requestGET(@NonNull HttpRequest request) throws IOException {
        HttpResponse result = this.delegate.requestGET(request);
        try {
            return this.interceptor.handle(this.delegate, request, result);
        }
        catch (Throwable ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)result);
            throw ex;
        }
    }

    @Generated
    public InterceptingClient(@lombok.NonNull HttpClient delegate, @lombok.NonNull Interceptor interceptor) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (interceptor == null) {
            throw new NullPointerException("interceptor is marked non-null but is null");
        }
        this.delegate = delegate;
        this.interceptor = interceptor;
    }

    @FunctionalInterface
    public static interface Interceptor {
        public @NonNull HttpResponse handle(@NonNull HttpClient var1, @NonNull HttpRequest var2, @NonNull HttpResponse var3) throws IOException;
    }
}

