/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http.ext;

import internal.util.http.HttpClient;
import internal.util.http.HttpRequest;
import internal.util.http.HttpResponse;
import internal.util.http.MediaType;
import internal.util.http.ext.TeeInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import lombok.Generated;
import nbbrd.io.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DumpingClient
implements HttpClient {
    @lombok.NonNull
    private final Path folder;
    @lombok.NonNull
    private final HttpClient delegate;
    @lombok.NonNull
    private final Consumer<? super Path> onDump;

    @Override
    public @NonNull HttpResponse requestGET(@NonNull HttpRequest request) throws IOException {
        return new DumpingResponse(this.folder, this.delegate.requestGET(request), this.onDump);
    }

    @Generated
    public DumpingClient(@lombok.NonNull Path folder, @lombok.NonNull HttpClient delegate, @lombok.NonNull Consumer<? super Path> onDump) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (onDump == null) {
            throw new NullPointerException("onDump is marked non-null but is null");
        }
        this.folder = folder;
        this.delegate = delegate;
        this.onDump = onDump;
    }

    private static final class DumpingResponse
    implements HttpResponse {
        @lombok.NonNull
        private final Path folder;
        @lombok.NonNull
        private final HttpResponse delegate;
        @lombok.NonNull
        private final Consumer<? super Path> onDump;

        @Override
        public @NonNull MediaType getContentType() throws IOException {
            return this.delegate.getContentType();
        }

        @Override
        public @NonNull InputStream getBody() throws IOException {
            InputStream inputStream = this.delegate.getBody();
            try {
                OutputStream outputStream = this.getDumpStream();
                return new TeeInputStream(inputStream, outputStream);
            }
            catch (IOException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)inputStream);
                throw ex;
            }
        }

        private OutputStream getDumpStream() throws IOException {
            Files.createDirectories(this.folder, new FileAttribute[0]);
            Path dump = Files.createTempFile(this.folder, "body", ".tmp", new FileAttribute[0]);
            this.onDump.accept(dump);
            return Files.newOutputStream(dump, new OpenOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Generated
        public DumpingResponse(@lombok.NonNull Path folder, @lombok.NonNull HttpResponse delegate, @lombok.NonNull Consumer<? super Path> onDump) {
            if (folder == null) {
                throw new NullPointerException("folder is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (onDump == null) {
                throw new NullPointerException("onDump is marked non-null but is null");
            }
            this.folder = folder;
            this.delegate = delegate;
            this.onDump = onDump;
        }
    }
}

