/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http.curl;

import internal.util.http.HttpConstants;
import internal.util.http.HttpHeadersBuilder;
import internal.util.http.curl.Curl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.sys.EndOfProcessException;
import nbbrd.io.sys.ProcessReader;

final class CurlHttpURLConnection
extends HttpURLConnection {
    @Generated
    private static final Logger log = Logger.getLogger(CurlHttpURLConnection.class.getName());
    @NonNull
    private final Proxy proxy;
    private final boolean insecure;
    private Map<String, List<String>> headerFields = Collections.emptyMap();
    private Path body = null;

    @VisibleForTesting
    CurlHttpURLConnection(URL url, Proxy proxy, boolean insecure) {
        super(url);
        this.proxy = proxy;
        this.insecure = insecure;
    }

    @Override
    public boolean usingProxy() {
        return HttpConstants.hasProxy(this.proxy);
    }

    @Override
    public void connect() throws IOException {
        Path output = Files.createTempFile("body", ".tmp", new FileAttribute[0]);
        String[] request = this.createCurlCommand(output);
        Curl.CurlHead responseHead = this.executeCurlCommand(request);
        this.responseCode = responseHead.getCode();
        this.responseMessage = responseHead.getMessage();
        this.headerFields = responseHead.getHeaders();
        this.body = output;
    }

    @Override
    public void disconnect() {
        if (this.body != null && Files.exists(this.body, new LinkOption[0])) {
            try {
                Files.delete(this.body);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    @Override
    public String getHeaderField(String name) {
        return HttpHeadersBuilder.lastValueOrNull(this.headerFields, name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.body, new OpenOption[0]);
    }

    @VisibleForTesting
    String[] createCurlCommand(Path output) {
        return new Curl.CurlCommandBuilder().url(this.getURL()).http1_1().silent().insecure(this.insecure).proxy(this.proxy).output(output).dumpHeader("-").connectTimeout((float)this.getConnectTimeout() / 1000.0f).maxTime((float)this.getReadTimeout() / 1000.0f).headers(this.getRequestProperties()).build();
    }

    private Curl.CurlHead executeCurlCommand(String[] command) throws IOException {
        Curl.CurlHead curlHead;
        block15: {
            if (log.isLoggable(Level.FINE)) {
                log.fine(Arrays.toString(command));
            }
            BufferedReader reader = ProcessReader.newReader((String[])command);
            try {
                curlHead = Curl.CurlHead.parseResponse(reader);
                if (reader == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EndOfProcessException ex) {
                    switch (ex.getExitValue()) {
                        case 1: {
                            throw new IOException("Unsupported protocol '" + this.getURL().getProtocol() + "'");
                        }
                        case 6: {
                            throw new UnknownHostException(this.getURL().getHost());
                        }
                        case 28: {
                            throw new IOException("Read timed out");
                        }
                        case 56: {
                            throw new IOException(CurlHttpURLConnection.getFailureReceivingNetworkDataMessage(this.proxy));
                        }
                    }
                    throw ex;
                }
            }
            reader.close();
        }
        return curlHead;
    }

    private static String getFailureReceivingNetworkDataMessage(Proxy proxy) {
        String result = "Failure in receiving network data.";
        if (HttpConstants.hasProxy(proxy)) {
            result = "Unable to tunnel through proxy. " + result;
        }
        return result;
    }
}

