/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http.curl;

import internal.util.http.HttpConstants;
import internal.util.http.HttpHeadersBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Curl {
    public static final int CURL_UNSUPPORTED_PROTOCOL = 1;
    public static final int CURL_COULD_NOT_RESOLVE_HOST = 6;
    public static final int CURL_OPERATION_TIMEOUT = 28;
    public static final int CURL_FAILURE_RECEIVING = 56;

    @Generated
    private Curl() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class CurlCommandBuilder {
        private final List<String> items = new ArrayList<String>();

        public CurlCommandBuilder() {
            this.items.add("curl");
        }

        private CurlCommandBuilder push(String item) {
            this.items.add(item);
            return this;
        }

        public CurlCommandBuilder url(URL url) {
            return this.push(url.toString());
        }

        public CurlCommandBuilder proxy(Proxy proxy) {
            if (HttpConstants.hasProxy(proxy)) {
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                this.push("-x").push(address.getHostString() + ":" + address.getPort());
            }
            return this;
        }

        public CurlCommandBuilder output(Path file) {
            return this.push("-o").push(file.toString());
        }

        public CurlCommandBuilder silent() {
            return this.push("-s");
        }

        public CurlCommandBuilder dumpHeader(String filename) {
            return this.push("-D").push(filename);
        }

        public CurlCommandBuilder connectTimeout(float seconds) {
            return this.push("--connect-timeout").push(this.fixNumericalParameter(seconds));
        }

        public CurlCommandBuilder maxTime(float seconds) {
            return this.push("-m").push(this.fixNumericalParameter(seconds));
        }

        public CurlCommandBuilder insecure(boolean insecure) {
            return insecure ? this.insecure() : this;
        }

        public CurlCommandBuilder insecure() {
            return this.push("-k");
        }

        public CurlCommandBuilder header(String key, String value) {
            return this.push("-H").push(key + ": " + value);
        }

        public CurlCommandBuilder headers(Map<String, List<String>> headers) {
            HttpHeadersBuilder.keyValues(headers).forEach(header -> this.header((String)header.getKey(), (String)header.getValue()));
            return this;
        }

        public CurlCommandBuilder version() {
            return this.push("-V");
        }

        public CurlCommandBuilder http1_1() {
            return this.push("--http1.1");
        }

        public String[] build() {
            return this.items.toArray(new String[0]);
        }

        private String fixNumericalParameter(float seconds) {
            return Integer.toString((int)seconds);
        }
    }

    public static final class CurlVersion {
        private final List<String> lines;

        public static CurlVersion parse(BufferedReader reader) throws IOException {
            Builder result = new Builder();
            try {
                reader.lines().forEach(result::line);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
            return result.build();
        }

        @Generated
        CurlVersion(List<String> lines) {
            this.lines = lines;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public List<String> getLines() {
            return this.lines;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurlVersion)) {
                return false;
            }
            CurlVersion other = (CurlVersion)o;
            List<String> this$lines = this.getLines();
            List<String> other$lines = other.getLines();
            return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "Curl.CurlVersion(lines=" + this.getLines() + ")";
        }

        public static final class Builder {
            @Generated
            private ArrayList<String> lines;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder line(String line) {
                if (this.lines == null) {
                    this.lines = new ArrayList();
                }
                this.lines.add(line);
                return this;
            }

            @Generated
            public @NonNull Builder lines(@NonNull Collection<? extends String> lines) {
                if (lines == null) {
                    throw new NullPointerException("lines cannot be null");
                }
                if (this.lines == null) {
                    this.lines = new ArrayList();
                }
                this.lines.addAll(lines);
                return this;
            }

            @Generated
            public @NonNull Builder clearLines() {
                if (this.lines != null) {
                    this.lines.clear();
                }
                return this;
            }

            @Generated
            public @NonNull CurlVersion build() {
                List<String> lines;
                switch (this.lines == null ? 0 : this.lines.size()) {
                    case 0: {
                        lines = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        lines = Collections.singletonList(this.lines.get(0));
                        break;
                    }
                    default: {
                        lines = Collections.unmodifiableList(new ArrayList<String>(this.lines));
                    }
                }
                return new CurlVersion(lines);
            }

            @Generated
            public @NonNull String toString() {
                return "Curl.CurlVersion.Builder(lines=" + this.lines + ")";
            }
        }
    }

    public static final class CurlHead {
        private final int code;
        private final String message;
        private final Map<String, List<String>> headers;
        private static char SP = (char)32;

        public static CurlHead parseResponse(BufferedReader reader) throws IOException {
            Builder result = new Builder();
            CurlHead.parseStatusLine(reader, result);
            CurlHead.parseHeaders(reader, result);
            return result.build();
        }

        private static void parseStatusLine(BufferedReader reader, Builder result) throws IOException {
            String statusLine = reader.readLine();
            if (statusLine == null) {
                return;
            }
            int codeStart = statusLine.indexOf(SP);
            if (codeStart == -1) {
                return;
            }
            int codeEnd = statusLine.indexOf(SP, codeStart + 1);
            if (codeEnd == -1) {
                result.code(Integer.parseInt(statusLine.substring(codeStart + 1)));
            } else {
                result.code(Integer.parseInt(statusLine.substring(codeStart + 1, codeEnd))).message(statusLine.substring(codeEnd + 1));
            }
        }

        private static void parseHeaders(BufferedReader reader, Builder result) throws IOException {
            String line;
            HttpHeadersBuilder headers = new HttpHeadersBuilder();
            while ((line = reader.readLine()) != null && !line.isEmpty()) {
                int index = line.indexOf(":");
                if (index == -1) continue;
                headers.put(line.substring(0, index), line.substring(index + 1).trim());
            }
            result.headers(headers.build());
        }

        @Generated
        private static int $default$code() {
            return -1;
        }

        @Generated
        private static String $default$message() {
            return null;
        }

        @Generated
        private static Map<String, List<String>> $default$headers() {
            return Collections.emptyMap();
        }

        @Generated
        CurlHead(int code, String message, Map<String, List<String>> headers) {
            this.code = code;
            this.message = message;
            this.headers = headers;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurlHead)) {
                return false;
            }
            CurlHead other = (CurlHead)o;
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.getHeaders();
            Map<String, List<String>> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Map<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "Curl.CurlHead(code=" + this.getCode() + ", message=" + this.getMessage() + ", headers=" + this.getHeaders() + ")";
        }

        public static final class Builder {
            @Generated
            private boolean code$set;
            @Generated
            private int code$value;
            @Generated
            private boolean message$set;
            @Generated
            private String message$value;
            @Generated
            private boolean headers$set;
            @Generated
            private Map<String, List<String>> headers$value;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder code(int code) {
                this.code$value = code;
                this.code$set = true;
                return this;
            }

            @Generated
            public @NonNull Builder message(String message) {
                this.message$value = message;
                this.message$set = true;
                return this;
            }

            @Generated
            public @NonNull Builder headers(Map<String, List<String>> headers) {
                this.headers$value = headers;
                this.headers$set = true;
                return this;
            }

            @Generated
            public @NonNull CurlHead build() {
                int code$value = this.code$value;
                if (!this.code$set) {
                    code$value = CurlHead.$default$code();
                }
                String message$value = this.message$value;
                if (!this.message$set) {
                    message$value = CurlHead.$default$message();
                }
                Map headers$value = this.headers$value;
                if (!this.headers$set) {
                    headers$value = CurlHead.$default$headers();
                }
                return new CurlHead(code$value, message$value, headers$value);
            }

            @Generated
            public @NonNull String toString() {
                return "Curl.CurlHead.Builder(code$value=" + this.code$value + ", message$value=" + this.message$value + ", headers$value=" + this.headers$value + ")";
            }
        }
    }
}

