/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MediaType {
    @VisibleForTesting
    static final String WILDCARD = "*";
    @VisibleForTesting
    static final String CHARSET_PARAMETER = "charset";
    public static final MediaType ANY_TYPE = new MediaType("*", "*", Collections.emptyMap());
    @lombok.NonNull
    private final String type;
    @lombok.NonNull
    private final String subtype;
    @lombok.NonNull
    private final Map<String, Collection<String>> parameters;

    public static @NonNull MediaType parse(@NonNull CharSequence text) throws IllegalArgumentException {
        String input = text.toString();
        if (MediaType.isEmptyOrTrimable(input)) {
            throw new IllegalArgumentException("Content is empty or trimable");
        }
        int subtypeIndex = input.indexOf(47);
        if (subtypeIndex == -1) {
            throw new IllegalArgumentException("Missing subtype");
        }
        String type = input.substring(0, subtypeIndex).toLowerCase();
        if (MediaType.isEmptyOrTrimable(type)) {
            throw new IllegalArgumentException("Type is empty or trimable");
        }
        int paramsIndex = input.indexOf(59, subtypeIndex);
        String subType = input.substring(subtypeIndex + 1, paramsIndex != -1 ? paramsIndex : input.length()).toLowerCase();
        if (MediaType.isEmptyOrTrimable(subType)) {
            throw new IllegalArgumentException("Subtype is empty or trimable");
        }
        if (paramsIndex == -1) {
            return new MediaType(type, subType, Collections.emptyMap());
        }
        HashMap<String, Collection> parameters = new HashMap<String, Collection>();
        for (String parameter : input.substring(paramsIndex + 1).split(";", -1)) {
            String[] keyValuePair = parameter.split("=", -1);
            if (keyValuePair.length != 2) {
                throw new IllegalArgumentException("Invalid key-value pair");
            }
            parameters.computeIfAbsent(MediaType.cleanParameter(keyValuePair[0]), o -> new ArrayList()).add(MediaType.cleanParameter(keyValuePair[1]));
        }
        return new MediaType(type, subType, Collections.unmodifiableMap(parameters));
    }

    public boolean isCompatible(@NonNull MediaType other) {
        return !(!other.type.equals(WILDCARD) && !other.type.equals(this.type) || !other.subtype.equals(WILDCARD) && !other.subtype.equals(this.subtype) || !MediaType.containsAll(this.parameters, other.parameters));
    }

    public boolean isCompatibleWithoutParameters(@NonNull MediaType other) {
        return !(!other.type.equals(WILDCARD) && !other.type.equals(this.type) || !other.subtype.equals(WILDCARD) && !other.subtype.equals(this.subtype));
    }

    public @NonNull Optional<Charset> getCharset() {
        Collection<String> charsets = this.parameters.get(CHARSET_PARAMETER);
        return charsets != null ? MediaType.findFirstCharset(charsets) : Optional.empty();
    }

    public @NonNull MediaType withoutParameters() {
        return this.parameters.isEmpty() ? this : new MediaType(this.type, this.subtype, Collections.emptyMap());
    }

    public @NonNull MediaType withCharset(@NonNull Charset charset) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(this.parameters);
        result.put(CHARSET_PARAMETER, Collections.singletonList(charset.name()));
        return new MediaType(this.type, this.subtype, Collections.unmodifiableMap(result));
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.type).append("/").append(this.subtype);
        this.parameters.forEach((k, v) -> v.forEach(o -> result.append("; ").append((String)k).append("=").append((String)o)));
        return result.toString();
    }

    private static boolean containsAll(Map<String, Collection<String>> l, Map<String, Collection<String>> r) {
        for (Map.Entry<String, Collection<String>> entry : r.entrySet()) {
            Collection<String> values = l.get(entry.getKey());
            if (values != null && values.containsAll(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static Optional<Charset> findFirstCharset(Collection<String> charsets) {
        return charsets.stream().map(arg_0 -> ((Parser)Parser.onCharset()).parse(arg_0)).filter(Objects::nonNull).findFirst();
    }

    private static String cleanParameter(String input) {
        return input.toLowerCase(Locale.ROOT).trim();
    }

    private static boolean isEmptyOrTrimable(String o) {
        return o.isEmpty() || !o.trim().equals(o);
    }

    @Generated
    public MediaType(@lombok.NonNull String type, @lombok.NonNull String subtype, @lombok.NonNull Map<String, Collection<String>> parameters) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (subtype == null) {
            throw new NullPointerException("subtype is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subtype = this.getSubtype();
        String other$subtype = other.getSubtype();
        if (this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype)) {
            return false;
        }
        Map<String, Collection<String>> this$parameters = this.getParameters();
        Map<String, Collection<String>> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subtype = this.getSubtype();
        result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
        Map<String, Collection<String>> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @lombok.NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @lombok.NonNull
    @Generated
    public String getSubtype() {
        return this.subtype;
    }

    @lombok.NonNull
    @Generated
    public Map<String, Collection<String>> getParameters() {
        return this.parameters;
    }
}

