/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http;

import internal.util.http.MediaType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HttpRequest {
    @lombok.NonNull
    private final URL query;
    private final List<MediaType> mediaTypes;
    @lombok.NonNull
    private final String langs;

    @Generated
    private static String $default$langs() {
        return "";
    }

    @Generated
    HttpRequest(@lombok.NonNull URL query, List<MediaType> mediaTypes, @lombok.NonNull String langs) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (langs == null) {
            throw new NullPointerException("langs is marked non-null but is null");
        }
        this.query = query;
        this.mediaTypes = mediaTypes;
        this.langs = langs;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().query(this.query).langs(this.langs);
        if (this.mediaTypes != null) {
            builder.mediaTypes(this.mediaTypes);
        }
        return builder;
    }

    @lombok.NonNull
    @Generated
    public URL getQuery() {
        return this.query;
    }

    @Generated
    public List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    @lombok.NonNull
    @Generated
    public String getLangs() {
        return this.langs;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        URL this$query = this.getQuery();
        URL other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        List<MediaType> this$mediaTypes = this.getMediaTypes();
        List<MediaType> other$mediaTypes = other.getMediaTypes();
        if (this$mediaTypes == null ? other$mediaTypes != null : !((Object)this$mediaTypes).equals(other$mediaTypes)) {
            return false;
        }
        String this$langs = this.getLangs();
        String other$langs = other.getLangs();
        return !(this$langs == null ? other$langs != null : !this$langs.equals(other$langs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URL $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        List<MediaType> $mediaTypes = this.getMediaTypes();
        result = result * 59 + ($mediaTypes == null ? 43 : ((Object)$mediaTypes).hashCode());
        String $langs = this.getLangs();
        result = result * 59 + ($langs == null ? 43 : $langs.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HttpRequest(query=" + this.getQuery() + ", mediaTypes=" + this.getMediaTypes() + ", langs=" + this.getLangs() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private URL query;
        @Generated
        private ArrayList<MediaType> mediaTypes;
        @Generated
        private boolean langs$set;
        @Generated
        private String langs$value;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder query(@lombok.NonNull URL query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        @Generated
        public @NonNull Builder mediaType(MediaType mediaType) {
            if (this.mediaTypes == null) {
                this.mediaTypes = new ArrayList();
            }
            this.mediaTypes.add(mediaType);
            return this;
        }

        @Generated
        public @NonNull Builder mediaTypes(@NonNull Collection<? extends MediaType> mediaTypes) {
            if (mediaTypes == null) {
                throw new NullPointerException("mediaTypes cannot be null");
            }
            if (this.mediaTypes == null) {
                this.mediaTypes = new ArrayList();
            }
            this.mediaTypes.addAll(mediaTypes);
            return this;
        }

        @Generated
        public @NonNull Builder clearMediaTypes() {
            if (this.mediaTypes != null) {
                this.mediaTypes.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder langs(@lombok.NonNull String langs) {
            if (langs == null) {
                throw new NullPointerException("langs is marked non-null but is null");
            }
            this.langs$value = langs;
            this.langs$set = true;
            return this;
        }

        @Generated
        public @NonNull HttpRequest build() {
            List<MediaType> mediaTypes;
            switch (this.mediaTypes == null ? 0 : this.mediaTypes.size()) {
                case 0: {
                    mediaTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    mediaTypes = Collections.singletonList(this.mediaTypes.get(0));
                    break;
                }
                default: {
                    mediaTypes = Collections.unmodifiableList(new ArrayList<MediaType>(this.mediaTypes));
                }
            }
            String langs$value = this.langs$value;
            if (!this.langs$set) {
                langs$value = HttpRequest.$default$langs();
            }
            return new HttpRequest(this.query, mediaTypes, langs$value);
        }

        @Generated
        public @NonNull String toString() {
            return "HttpRequest.Builder(query=" + this.query + ", mediaTypes=" + this.mediaTypes + ", langs$value=" + this.langs$value + ")";
        }
    }
}

