/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http;

import internal.util.http.HttpAuthScheme;
import internal.util.http.HttpAuthenticator;
import internal.util.http.HttpEventListener;
import internal.util.http.HttpRequest;
import internal.util.http.MediaType;
import internal.util.http.StreamDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class HttpImpl {
    @Generated
    private HttpImpl() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static enum StreamDecoders implements StreamDecoder
    {
        NONE{

            @Override
            public @NonNull InputStream decode(@NonNull InputStream stream) {
                Objects.requireNonNull(stream);
                return stream;
            }
        }
        ,
        GZIP{

            @Override
            public @NonNull InputStream decode(@NonNull InputStream stream) throws IOException {
                return new GZIPInputStream(stream);
            }
        }
        ,
        DEFLATE{

            @Override
            public @NonNull InputStream decode(@NonNull InputStream stream) {
                return new InflaterInputStream(stream);
            }
        };


        @Override
        public @NonNull String getName() {
            return this.name().toLowerCase();
        }
    }

    static enum EventListeners implements HttpEventListener
    {
        NONE{

            @Override
            public void onOpen(HttpRequest request, Proxy proxy, HttpAuthScheme scheme) {
                Objects.requireNonNull(request);
                Objects.requireNonNull(proxy);
                Objects.requireNonNull(scheme);
            }

            @Override
            public void onSuccess(@NonNull MediaType mediaType) {
                Objects.requireNonNull(mediaType);
            }

            @Override
            public void onRedirection(URL oldUrl, URL newUrl) {
                Objects.requireNonNull(oldUrl);
                Objects.requireNonNull(newUrl);
            }

            @Override
            public void onUnauthorized(URL url, HttpAuthScheme oldScheme, HttpAuthScheme newScheme) {
                Objects.requireNonNull(url);
                Objects.requireNonNull(oldScheme);
                Objects.requireNonNull(newScheme);
            }

            @Override
            public void onEvent(@NonNull String message) {
                Objects.requireNonNull(message);
            }
        };

    }

    static enum Authenticators implements HttpAuthenticator
    {
        NONE{

            @Override
            public @Nullable PasswordAuthentication getPasswordAuthentication(@NonNull URL url) {
                Objects.requireNonNull(url);
                return null;
            }

            @Override
            public void invalidate(@NonNull URL url) {
                Objects.requireNonNull(url);
            }
        };

    }
}

