/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HttpHeadersBuilder {
    private final List<Map.Entry<String, String>> data = new ArrayList<Map.Entry<String, String>>();
    private BiPredicate<String, String> filter = HttpHeadersBuilder::valueNotNullNorEmpty;
    private static final Collector<Map.Entry<String, String>, ?, Map<String, List<String>>> COLLECTOR = Collectors.collectingAndThen(Collectors.groupingBy(Map.Entry::getKey, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER), HttpHeadersBuilder.toUnmodifiableList(Map.Entry::getValue)), Collections::unmodifiableMap);

    private static boolean valueNotNullNorEmpty(String k, String v) {
        return v != null && !v.isEmpty();
    }

    public @NonNull HttpHeadersBuilder put(@NonNull Map<String, List<String>> headers) {
        Objects.requireNonNull(headers);
        HttpHeadersBuilder.keyValues(headers).forEach(this.data::add);
        return this;
    }

    public @NonNull HttpHeadersBuilder put(@NonNull String key, @Nullable String value) {
        this.data.add(HttpHeadersBuilder.headerOf(key, value));
        return this;
    }

    public @NonNull HttpHeadersBuilder filter(@NonNull BiPredicate<String, String> filter) {
        Objects.requireNonNull(filter);
        this.filter = filter;
        return this;
    }

    public @NonNull Map<String, List<String>> build() {
        return this.data.stream().filter((? super T header) -> this.filter.test((String)header.getKey(), (String)header.getValue())).collect(COLLECTOR);
    }

    private static <T, U> Collector<T, ?, List<U>> toUnmodifiableList(Function<? super T, ? extends U> mapper) {
        return Collectors.mapping(mapper, HttpHeadersBuilder.toUnmodifiableList());
    }

    private static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    private static @NonNull Map.Entry<String, String> headerOf(@NonNull String key, @Nullable String value) {
        Objects.requireNonNull(key);
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    public static @Nullable String lastValueOrNull(@NonNull Map<String, List<String>> headers, @NonNull String name) {
        List<String> header = headers.get(name);
        return header != null && !header.isEmpty() ? header.get(header.size() - 1) : null;
    }

    public static @NonNull Stream<Map.Entry<String, String>> keyValues(@NonNull Map<String, List<String>> headers) {
        return headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> HttpHeadersBuilder.headerOf((String)entry.getKey(), value)));
    }
}

