/*
 * Decompiled with CFR 0.152.
 */
package internal.util.http;

import internal.util.http.HttpAuthScheme;
import internal.util.http.HttpAuthenticator;
import internal.util.http.HttpClient;
import internal.util.http.HttpConstants;
import internal.util.http.HttpContext;
import internal.util.http.HttpHeadersBuilder;
import internal.util.http.HttpRequest;
import internal.util.http.HttpResponse;
import internal.util.http.HttpResponseException;
import internal.util.http.HttpURLConnectionFactory;
import internal.util.http.MediaType;
import internal.util.http.StreamDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;

public final class DefaultHttpClient
implements HttpClient {
    @NonNull
    private final HttpContext context;
    @NonNull
    private final HttpURLConnectionFactory factory;

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull HttpResponse requestGET(@org.checkerframework.checker.nullness.qual.NonNull HttpRequest request) throws IOException {
        Objects.requireNonNull(request);
        return this.open(request, 0, this.getPreemptiveAuthScheme());
    }

    private HttpResponse open(HttpRequest request, int redirects, AuthSchemeHelper requestScheme) throws IOException {
        if (!HttpConstants.isHttpProtocol(request.getQuery()) && !HttpConstants.isHttpsProtocol(request.getQuery())) {
            throw new IOException("Unsupported protocol '" + request.getQuery().getProtocol() + "'");
        }
        if (!requestScheme.isSecureRequest(request.getQuery())) {
            throw new IOException("Insecure protocol for " + (Object)((Object)requestScheme) + " auth on '" + request.getQuery() + "'");
        }
        Proxy proxy = this.getProxy(request.getQuery());
        HttpURLConnection connection = this.openConnection(request, requestScheme, proxy);
        switch (HttpConstants.ResponseType.parse(connection.getResponseCode())) {
            case REDIRECTION: {
                return this.redirect(connection, request, redirects);
            }
            case SUCCESSFUL: {
                return this.getBody(connection);
            }
            case CLIENT_ERROR: {
                return this.recoverClientError(connection, request, redirects, requestScheme);
            }
        }
        throw this.getError(connection);
    }

    private HttpURLConnection openConnection(HttpRequest request, AuthSchemeHelper requestScheme, Proxy proxy) throws IOException {
        HttpURLConnection result = this.factory.openConnection(request.getQuery(), proxy);
        result.setReadTimeout(this.context.getReadTimeout());
        result.setConnectTimeout(this.context.getConnectTimeout());
        if (result instanceof HttpsURLConnection) {
            ((HttpsURLConnection)result).setSSLSocketFactory(this.context.getSslSocketFactory().get());
            ((HttpsURLConnection)result).setHostnameVerifier(this.context.getHostnameVerifier().get());
        }
        Map<String, List<String>> headers = new HttpHeadersBuilder().put("Accept", DefaultHttpClient.toAcceptHeader(request.getMediaTypes())).put("Accept-Language", request.getLangs()).put("Accept-Encoding", this.getEncodingHeader()).put("User-Agent", this.context.getUserAgent()).put(requestScheme.getRequestHeaders(request.getQuery(), this.context.getAuthenticator())).build();
        result.setRequestMethod("GET");
        result.setInstanceFollowRedirects(false);
        HttpHeadersBuilder.keyValues(headers).forEach(header -> result.setRequestProperty((String)header.getKey(), (String)header.getValue()));
        this.context.getListener().onOpen(request, proxy, requestScheme.authScheme);
        result.connect();
        return result;
    }

    private String getEncodingHeader() {
        return this.context.getDecoders().stream().map(StreamDecoder::getName).collect(Collectors.joining(", "));
    }

    private AuthSchemeHelper getPreemptiveAuthScheme() {
        return this.context.isPreemptiveAuthentication() ? AuthSchemeHelper.BASIC : AuthSchemeHelper.NONE;
    }

    private Proxy getProxy(URL url) throws IOException {
        List<Proxy> proxies = this.context.getProxySelector().get().select(DefaultHttpClient.toURI(url));
        return proxies.isEmpty() ? Proxy.NO_PROXY : proxies.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse redirect(HttpURLConnection connection, HttpRequest request, int redirects) throws IOException {
        URL newUrl;
        URL oldUrl = request.getQuery();
        try {
            if (redirects == this.context.getMaxRedirects()) {
                throw new IOException("Max redirection reached");
            }
            String location = connection.getHeaderField("Location");
            if (location == null || location.isEmpty()) {
                throw new IOException("Missing redirection url");
            }
            newUrl = new URL(oldUrl, URLDecoder.decode(location, StandardCharsets.UTF_8.name()));
        }
        finally {
            DefaultHttpClient.doClose(connection);
        }
        if (HttpConstants.isDowngradingProtocolOnRedirect(oldUrl, newUrl)) {
            throw new IOException("Downgrading protocol on redirect from '" + oldUrl + "' to '" + newUrl + "'");
        }
        this.context.getListener().onRedirection(oldUrl, newUrl);
        return this.open(request.toBuilder().query(newUrl).build(), redirects + 1, this.getPreemptiveAuthScheme());
    }

    private HttpResponse recoverClientError(HttpURLConnection connection, HttpRequest request, int redirects, AuthSchemeHelper requestScheme) throws IOException {
        if (connection.getResponseCode() == 401) {
            AuthSchemeHelper responseScheme = AuthSchemeHelper.parse(connection).orElse(AuthSchemeHelper.BASIC);
            if (!requestScheme.equals((Object)responseScheme)) {
                this.context.getListener().onUnauthorized(connection.getURL(), requestScheme.authScheme, responseScheme.authScheme);
                return this.open(request, redirects + 1, responseScheme);
            }
            this.context.getAuthenticator().invalidate(connection.getURL());
        }
        throw this.getError(connection);
    }

    private HttpResponse getBody(HttpURLConnection connection) throws IOException {
        DefaultResponse result = new DefaultResponse(connection, this.context.getDecoders());
        this.context.getListener().onSuccess(result.getContentType());
        return result;
    }

    private IOException getError(HttpURLConnection connection) throws IOException {
        try {
            HttpResponseException httpResponseException = new HttpResponseException(connection.getResponseCode(), connection.getResponseMessage(), connection.getHeaderFields());
            return httpResponseException;
        }
        finally {
            DefaultHttpClient.doClose(connection);
        }
    }

    private static void doClose(HttpURLConnection connection) throws IOException {
        try {
            connection.disconnect();
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    @VisibleForTesting
    static @org.checkerframework.checker.nullness.qual.NonNull String toAcceptHeader(@org.checkerframework.checker.nullness.qual.NonNull List<MediaType> mediaTypes) {
        return mediaTypes.stream().map(MediaType::toString).collect(Collectors.joining(", "));
    }

    private static URI toURI(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    @Generated
    public DefaultHttpClient(@NonNull HttpContext context, @NonNull HttpURLConnectionFactory factory) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.context = context;
        this.factory = factory;
    }

    private static final class DefaultResponse
    implements HttpResponse {
        @NonNull
        private final HttpURLConnection conn;
        @NonNull
        private final List<StreamDecoder> decoders;

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull MediaType getContentType() throws IOException {
            String contentType = this.conn.getHeaderField("Content-Type");
            if (contentType == null) {
                throw new IOException("Content type not known");
            }
            try {
                return MediaType.parse(contentType);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid content type '" + contentType + "'", ex);
            }
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull InputStream getBody() throws IOException {
            String encodingOrNull = this.conn.getHeaderField("Content-Encoding");
            return this.decoders.stream().filter(decoder -> decoder.getName().equals(encodingOrNull)).findFirst().orElse(StreamDecoder.noOp()).decode(this.conn.getInputStream());
        }

        @Override
        public void close() throws IOException {
            DefaultHttpClient.doClose(this.conn);
        }

        @Generated
        public DefaultResponse(@NonNull HttpURLConnection conn, @NonNull List<StreamDecoder> decoders) {
            if (conn == null) {
                throw new NullPointerException("conn is marked non-null but is null");
            }
            if (decoders == null) {
                throw new NullPointerException("decoders is marked non-null but is null");
            }
            this.conn = conn;
            this.decoders = decoders;
        }
    }

    private static enum AuthSchemeHelper {
        BASIC(HttpAuthScheme.BASIC){

            @Override
            boolean isSecureRequest(URL url) {
                return HttpConstants.isHttpsProtocol(url);
            }

            @Override
            Map<String, List<String>> getRequestHeaders(URL url, HttpAuthenticator authenticator) {
                PasswordAuthentication auth = authenticator.getPasswordAuthentication(url);
                return auth != null ? new HttpHeadersBuilder().put("Authorization", AuthSchemeHelper.getBasicAuthHeader(auth)).build() : Collections.emptyMap();
            }

            @Override
            boolean hasResponseHeader(HttpURLConnection http) throws IOException {
                String value = http.getHeaderField("WWW-Authenticate");
                return value != null && value.startsWith("Basic");
            }
        }
        ,
        NONE(HttpAuthScheme.NONE){

            @Override
            boolean isSecureRequest(URL query) {
                return true;
            }

            @Override
            Map<String, List<String>> getRequestHeaders(URL query, HttpAuthenticator authenticator) {
                return Collections.emptyMap();
            }

            @Override
            boolean hasResponseHeader(HttpURLConnection http) {
                return false;
            }
        };

        private final HttpAuthScheme authScheme;

        abstract boolean isSecureRequest(URL var1);

        abstract Map<String, List<String>> getRequestHeaders(URL var1, HttpAuthenticator var2);

        abstract boolean hasResponseHeader(HttpURLConnection var1) throws IOException;

        static Optional<AuthSchemeHelper> parse(HttpURLConnection http) {
            return Stream.of(AuthSchemeHelper.values()).filter(authScheme -> {
                try {
                    return authScheme.hasResponseHeader(http);
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(exception);
                }
            }).findFirst();
        }

        private static String getBasicAuthHeader(PasswordAuthentication auth) {
            String basicAuth = auth.getUserName() + ':' + String.valueOf(auth.getPassword());
            return "Basic " + AuthSchemeHelper.toBase64(basicAuth);
        }

        private static String toBase64(String input) {
            return Base64.getEncoder().encodeToString(input.getBytes(StandardCharsets.UTF_8));
        }

        @Generated
        private AuthSchemeHelper(HttpAuthScheme authScheme) {
            this.authScheme = authScheme;
        }
    }
}

