/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.monitors;

import java.net.URI;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class UptimeRobotId {
    public static final String URI_SCHEME = "uptimerobot";
    @lombok.NonNull
    private final String apiKey;
    private final boolean logs;
    private final boolean allTimeUptimeRatio;
    private final boolean responseTimesAverage;

    public @NonNull String toBody() {
        return "api_key=" + this.apiKey + "&format=xml&logs=" + this.format(this.logs) + "&all_time_uptime_ratio=" + this.format(this.allTimeUptimeRatio) + "&response_times_average=" + this.format(this.responseTimesAverage);
    }

    private String format(boolean value) {
        return value ? "1" : "0";
    }

    public @NonNull URI toURI() {
        return URI.create("uptimerobot:" + this.apiKey);
    }

    public static @NonNull UptimeRobotId parse(@NonNull URI uri) {
        if (!uri.getScheme().equals(URI_SCHEME)) {
            throw new IllegalArgumentException("Invalid scheme");
        }
        return UptimeRobotId.builder().apiKey(uri.toString().substring(URI_SCHEME.length() + 1)).allTimeUptimeRatio(true).responseTimesAverage(false).build();
    }

    @Generated
    private static boolean $default$logs() {
        return false;
    }

    @Generated
    private static boolean $default$allTimeUptimeRatio() {
        return false;
    }

    @Generated
    private static boolean $default$responseTimesAverage() {
        return false;
    }

    @Generated
    UptimeRobotId(@lombok.NonNull String apiKey, boolean logs, boolean allTimeUptimeRatio, boolean responseTimesAverage) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.logs = logs;
        this.allTimeUptimeRatio = allTimeUptimeRatio;
        this.responseTimesAverage = responseTimesAverage;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public boolean isLogs() {
        return this.logs;
    }

    @Generated
    public boolean isAllTimeUptimeRatio() {
        return this.allTimeUptimeRatio;
    }

    @Generated
    public boolean isResponseTimesAverage() {
        return this.responseTimesAverage;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UptimeRobotId)) {
            return false;
        }
        UptimeRobotId other = (UptimeRobotId)o;
        if (this.isLogs() != other.isLogs()) {
            return false;
        }
        if (this.isAllTimeUptimeRatio() != other.isAllTimeUptimeRatio()) {
            return false;
        }
        if (this.isResponseTimesAverage() != other.isResponseTimesAverage()) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        return !(this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLogs() ? 79 : 97);
        result = result * 59 + (this.isAllTimeUptimeRatio() ? 79 : 97);
        result = result * 59 + (this.isResponseTimesAverage() ? 79 : 97);
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "UptimeRobotId(apiKey=" + this.getApiKey() + ", logs=" + this.isLogs() + ", allTimeUptimeRatio=" + this.isAllTimeUptimeRatio() + ", responseTimesAverage=" + this.isResponseTimesAverage() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String apiKey;
        @Generated
        private boolean logs$set;
        @Generated
        private boolean logs$value;
        @Generated
        private boolean allTimeUptimeRatio$set;
        @Generated
        private boolean allTimeUptimeRatio$value;
        @Generated
        private boolean responseTimesAverage$set;
        @Generated
        private boolean responseTimesAverage$value;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder apiKey(@lombok.NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public @NonNull Builder logs(boolean logs) {
            this.logs$value = logs;
            this.logs$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder allTimeUptimeRatio(boolean allTimeUptimeRatio) {
            this.allTimeUptimeRatio$value = allTimeUptimeRatio;
            this.allTimeUptimeRatio$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder responseTimesAverage(boolean responseTimesAverage) {
            this.responseTimesAverage$value = responseTimesAverage;
            this.responseTimesAverage$set = true;
            return this;
        }

        @Generated
        public @NonNull UptimeRobotId build() {
            boolean logs$value = this.logs$value;
            if (!this.logs$set) {
                logs$value = UptimeRobotId.$default$logs();
            }
            boolean allTimeUptimeRatio$value = this.allTimeUptimeRatio$value;
            if (!this.allTimeUptimeRatio$set) {
                allTimeUptimeRatio$value = UptimeRobotId.$default$allTimeUptimeRatio();
            }
            boolean responseTimesAverage$value = this.responseTimesAverage$value;
            if (!this.responseTimesAverage$set) {
                responseTimesAverage$value = UptimeRobotId.$default$responseTimesAverage();
            }
            return new UptimeRobotId(this.apiKey, logs$value, allTimeUptimeRatio$value, responseTimesAverage$value);
        }

        @Generated
        public @NonNull String toString() {
            return "UptimeRobotId.Builder(apiKey=" + this.apiKey + ", logs$value=" + this.logs$value + ", allTimeUptimeRatio$value=" + this.allTimeUptimeRatio$value + ", responseTimesAverage$value=" + this.responseTimesAverage$value + ")";
        }
    }
}

