/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.monitors;

import internal.sdmxdl.ri.web.monitors.UptimeRobotId;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import nbbrd.io.function.IOFunction;
import nbbrd.io.text.Parser;
import nbbrd.io.xml.Stax;
import nbbrd.io.xml.Xml;
import sdmxdl.util.web.SdmxWebEvents;
import sdmxdl.util.web.SdmxWebMonitors;
import sdmxdl.web.SdmxWebMonitorReport;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.SdmxWebStatus;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebMonitoring;

public final class UptimeRobot
implements SdmxWebMonitoring {
    private final URL url = (URL)Parser.onURL().parseValue((CharSequence)"https://api.uptimerobot.com/v2/getMonitors").orElseThrow(RuntimeException::new);
    private static final Parser<SdmxWebStatus> STATUS_PARSER = Parser.onEnum(Status.class, Status::getCode).andThen(Status::getReport);

    public String getUriScheme() {
        return "uptimerobot";
    }

    public SdmxWebMonitorReport getReport(SdmxWebSource source, SdmxWebContext context) throws IOException, IllegalArgumentException {
        SdmxWebMonitors.checkMonitor((URI)source.getMonitor(), (String)this.getUriScheme());
        UptimeRobotId id = UptimeRobotId.parse(source.getMonitor());
        Stax.StreamParser parser = Stax.StreamParser.valueOf(UptimeRobot::parseReport);
        return (SdmxWebMonitorReport)UptimeRobot.post(this.url, id.toBody(), arg_0 -> ((Xml.Parser)parser).parseReader(arg_0), context, source);
    }

    private static SdmxWebMonitorReport parseReport(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getLocalName().equals("monitor")) break;
                    return SdmxWebMonitorReport.builder().source(reader.getAttributeValue(null, "friendly_name")).status((SdmxWebStatus)STATUS_PARSER.parseValue((CharSequence)reader.getAttributeValue(null, "status")).orElseThrow(() -> new XMLStreamException("Cannot parse status"))).uptimeRatio((Double)Parser.onDouble().parse((CharSequence)reader.getAttributeValue(null, "all_time_uptime_ratio"))).averageResponseTime((Long)Parser.onLong().parse((CharSequence)reader.getAttributeValue(null, "average_response_time"))).build();
                }
            }
        }
        throw new RuntimeException("Not found");
    }

    private static URI toURI(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private static <T> T post(URL url, String query, IOFunction<Reader, T> factory, SdmxWebContext context, SdmxWebSource source) throws IOException {
        HttpURLConnection conn;
        byte[] data = query.getBytes(StandardCharsets.UTF_8);
        Proxy proxy = context.getNetwork().getProxySelector().select(UptimeRobot.toURI(url)).stream().findFirst().orElse(Proxy.NO_PROXY);
        if (context.getEventListener().isEnabled()) {
            context.getEventListener().onWebSourceEvent(source, SdmxWebEvents.onQuery((URL)url, (Proxy)proxy));
        }
        if ((conn = (HttpURLConnection)url.openConnection(proxy)) instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(context.getNetwork().getSslSocketFactory());
            ((HttpsURLConnection)conn).setHostnameVerifier(context.getNetwork().getHostnameVerifier());
        }
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("cache-control", "no-cache");
        conn.setRequestProperty("charset", "utf-8");
        conn.setRequestProperty("Content-Length", Integer.toString(data.length));
        conn.setUseCaches(false);
        try (OutputStream wr = conn.getOutputStream();){
            wr.write(data);
        }
        try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
            Object object = factory.applyWithIO((Object)reader);
            return (T)object;
        }
    }

    private static enum Status {
        PAUSED(0, SdmxWebStatus.UNKNOWN),
        NOT_CHECKED_YET(1, SdmxWebStatus.UNKNOWN),
        UP(2, SdmxWebStatus.UP),
        SEEMS_DOWN(8, SdmxWebStatus.DOWN),
        DOWN(9, SdmxWebStatus.DOWN);

        int code;
        SdmxWebStatus report;

        @Generated
        private Status(int code, SdmxWebStatus report) {
            this.code = code;
            this.report = report;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public SdmxWebStatus getReport() {
            return this.report;
        }
    }
}

