/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.monitors;

import com.google.gson.Gson;
import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.monitors.UpptimeId;
import internal.util.http.HttpClient;
import internal.util.http.HttpResponse;
import internal.util.http.MediaType;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.LanguagePriorityList;

class UpptimeSummary {
    String name;
    String status;
    String uptime;
    long time;
    private static final List<MediaType> MEDIA_TYPES = Collections.singletonList(MediaType.ANY_TYPE);

    static @NonNull List<UpptimeSummary> parseAll(@NonNull Reader reader) {
        return Arrays.asList((UpptimeSummary[])new Gson().fromJson(reader, UpptimeSummary[].class));
    }

    static @NonNull List<UpptimeSummary> request(@NonNull HttpClient client, @NonNull UpptimeId id) throws IOException {
        try (HttpResponse response = client.requestGET(RiHttpUtils.newRequest(id.toSummaryURL(), MEDIA_TYPES, LanguagePriorityList.ANY));){
            List<UpptimeSummary> list;
            block12: {
                Reader reader = response.getBodyAsReader();
                try {
                    list = UpptimeSummary.parseAll(reader);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return list;
        }
    }

    static @NonNull UpptimeSummary of(String name, String status, String uptime, long time) {
        UpptimeSummary result = new UpptimeSummary();
        result.setName(name);
        result.setStatus(status);
        result.setUptime(uptime);
        result.setTime(time);
        return result;
    }

    @Generated
    public UpptimeSummary() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public long getTime() {
        return this.time;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    @Generated
    public void setTime(long time) {
        this.time = time;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpptimeSummary)) {
            return false;
        }
        UpptimeSummary other = (UpptimeSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$uptime = this.getUptime();
        String other$uptime = other.getUptime();
        return !(this$uptime == null ? other$uptime != null : !this$uptime.equals(other$uptime));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpptimeSummary;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $uptime = this.getUptime();
        result = result * 59 + ($uptime == null ? 43 : $uptime.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "UpptimeSummary(name=" + this.getName() + ", status=" + this.getStatus() + ", uptime=" + this.getUptime() + ", time=" + this.getTime() + ")";
    }
}

