/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.monitors;

import internal.util.http.URLQueryBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class UpptimeId {
    public static final String URI_SCHEME = "upptime";
    @lombok.NonNull
    private final String owner;
    @lombok.NonNull
    private final String repo;
    @lombok.NonNull
    private final String site;

    public String toString() {
        return "upptime:/" + this.owner + "/" + this.repo + "/" + this.site;
    }

    public @NonNull URL toSummaryURL() throws MalformedURLException {
        return URLQueryBuilder.of(new URL("https://raw.githubusercontent.com")).path(this.owner).path(this.repo).path("master").path("history").path("summary.json").build();
    }

    public @NonNull URI toURI() {
        return URI.create(this.toString());
    }

    public static @NonNull UpptimeId parse(@NonNull URI uri) throws IllegalArgumentException {
        if (!uri.getScheme().equals(URI_SCHEME)) {
            throw new IllegalArgumentException("Invalid scheme");
        }
        String path = uri.getRawPath();
        if (path == null) {
            throw new IllegalArgumentException("Missing path");
        }
        String[] items = path.substring(1).split("/", -1);
        if (items.length != 3) {
            throw new IllegalArgumentException("Invalid path; expected 3 parts, found " + items.length);
        }
        return new UpptimeId(items[0], items[1], items[2]);
    }

    @Generated
    public UpptimeId(@lombok.NonNull String owner, @lombok.NonNull String repo, @lombok.NonNull String site) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (repo == null) {
            throw new NullPointerException("repo is marked non-null but is null");
        }
        if (site == null) {
            throw new NullPointerException("site is marked non-null but is null");
        }
        this.owner = owner;
        this.repo = repo;
        this.site = site;
    }

    @lombok.NonNull
    @Generated
    public String getOwner() {
        return this.owner;
    }

    @lombok.NonNull
    @Generated
    public String getRepo() {
        return this.repo;
    }

    @lombok.NonNull
    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpptimeId)) {
            return false;
        }
        UpptimeId other = (UpptimeId)o;
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$repo = this.getRepo();
        String other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        String this$site = this.getSite();
        String other$site = other.getSite();
        return !(this$site == null ? other$site != null : !this$site.equals(other$site));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        String $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        return result;
    }
}

