/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.monitors;

import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.monitors.UpptimeId;
import internal.sdmxdl.ri.web.monitors.UpptimeSummary;
import internal.util.http.HttpClient;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.ext.SdmxCache;
import sdmxdl.util.web.SdmxWebMonitors;
import sdmxdl.web.SdmxWebMonitorReport;
import sdmxdl.web.SdmxWebMonitorReports;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.SdmxWebStatus;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebMonitoring;

public class Upptime
implements SdmxWebMonitoring {
    private static final @NonNull Parser<Number> NUMBER_PARSER = Parser.onNumberFormat((NumberFormat)NumberFormat.getPercentInstance(Locale.ROOT));

    public @NonNull String getUriScheme() {
        return "upptime";
    }

    public @NonNull SdmxWebMonitorReport getReport(@NonNull SdmxWebSource source, @NonNull SdmxWebContext context) throws IOException, IllegalArgumentException {
        SdmxWebMonitors.checkMonitor((URI)source.getMonitor(), (String)this.getUriScheme());
        UpptimeId id = UpptimeId.parse(source.getMonitor());
        SdmxCache cache = context.getCache();
        String key = id.toSummaryURL().toString();
        SdmxWebMonitorReports reports = cache.getWebMonitorReports(key);
        if (reports == null) {
            reports = this.createReports(RiHttpUtils.newClient(source, context), id, cache.getClock());
            cache.putWebMonitorReports(key, reports);
        }
        return reports.getReports().stream().filter(item -> item.getSource().equals(id.getSite())).findFirst().orElseThrow(IOException::new);
    }

    private SdmxWebMonitorReports createReports(HttpClient client, UpptimeId id, Clock clock) throws IOException {
        return SdmxWebMonitorReports.builder().uriScheme(this.getUriScheme()).reports((Collection)UpptimeSummary.request(client, id).stream().map(Upptime::getReport).collect(Collectors.toList())).ttl(clock.instant(), Duration.ofMinutes(5L)).build();
    }

    @VisibleForTesting
    static SdmxWebMonitorReport getReport(UpptimeSummary summary) {
        return SdmxWebMonitorReport.builder().source(summary.getName()).status(Upptime.parseStatus(summary.getStatus())).uptimeRatio((Double)NUMBER_PARSER.parseValue((CharSequence)summary.getUptime()).map(Number::doubleValue).orElse(null)).averageResponseTime(Long.valueOf(summary.getTime())).build();
    }

    private static SdmxWebStatus parseStatus(String status) {
        switch (status) {
            case "up": {
                return SdmxWebStatus.UP;
            }
            case "down": {
                return SdmxWebStatus.DOWN;
            }
        }
        return SdmxWebStatus.UNKNOWN;
    }
}

