/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import com.google.gson.Gson;
import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.util.http.HttpClient;
import internal.util.http.HttpRequest;
import internal.util.http.HttpResponse;
import internal.util.http.URLQueryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.DataCursor;
import sdmxdl.DataRef;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.Series;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.SdmxCache;
import sdmxdl.ext.SdmxException;
import sdmxdl.repo.DataSet;
import sdmxdl.repo.SdmxRepository;
import sdmxdl.util.TypedId;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.util.web.SdmxWebProperty;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;
import sdmxdl.xml.stream.SdmxXmlStreams;

public final class StatCanDriver
implements SdmxWebDriver {
    private static final String RI_STATCAN = "ri:statcan";

    public @org.checkerframework.checker.nullness.qual.NonNull String getName() {
        return RI_STATCAN;
    }

    public int getRank() {
        return 127;
    }

    public boolean isAvailable() {
        return true;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull SdmxWebConnection connect(@org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebContext context) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(context);
        SdmxRestDriverSupport.checkSource((SdmxWebSource)source, (String)RI_STATCAN);
        DefaultStatCanClient client = new DefaultStatCanClient(source.getEndpoint().toURL(), context.getLanguages(), RiHttpUtils.newClient(source, context));
        CachedStatCanClient cachedClient = CachedStatCanClient.of(client, context.getCache(), SdmxWebProperty.CACHE_TTL_PROPERTY.get(source.getProperties()), source, context.getLanguages());
        return new StatCanConnection(source.getName(), cachedClient);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Collection<SdmxWebSource> getDefaultSources() {
        return Collections.singleton(SdmxWebSource.builder().name("STATCAN").description("Statistics Canada").driver(RI_STATCAN).endpointOf("https://www150.statcan.gc.ca/t1/wds/rest").websiteOf("https://www150.statcan.gc.ca/n1/en/type/data?MM=1").propertyOf((CharSequence)SdmxWebProperty.CACHE_TTL_PROPERTY, (Object)Long.toString(Duration.ofHours(1L).toMillis())).monitorOf("upptime:/nbbrd/sdmx-upptime/STATCAN").build());
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Collection<String> getSupportedProperties() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(RiHttpUtils.CONNECTION_PROPERTIES);
        result.add(SdmxWebProperty.CACHE_TTL_PROPERTY.getKey());
        return result;
    }

    @VisibleForTesting
    static final class Converter {
        static final String AGENCY = "StatCan";
        static final String FLOW_PREFIX = "DF_";
        static final String STRUCT_PREFIX = "Data_Structure_";
        static final String VERSION = "1.0";

        static DataflowRef toDataflowRef(int productId) {
            return DataflowRef.of((String)AGENCY, (String)(FLOW_PREFIX + productId), (String)VERSION);
        }

        static int fromDataflowRef(DataflowRef ref) {
            return Integer.parseInt(ref.getId().substring(FLOW_PREFIX.length()));
        }

        static DataStructureRef toDataStructureRef(int productId) {
            return DataStructureRef.of((String)AGENCY, (String)(STRUCT_PREFIX + productId), (String)VERSION);
        }

        static Dataflow toDataFlow(DataTable dataTable, LanguagePriorityList langs) {
            return Dataflow.of((DataflowRef)Converter.toDataflowRef(dataTable.getProductId()), (DataStructureRef)Converter.toDataStructureRef(dataTable.getProductId()), (String)("fr".equals(langs.lookupTag(Arrays.asList("en", "fr"))) ? dataTable.cubeTitleFr : dataTable.cubeTitleEn));
        }

        static SdmxRepository toSdmxRepository(File fullTable, int productId, LanguagePriorityList langs) throws IOException {
            try (ZipFile zipFile = new ZipFile(fullTable);){
                DataStructure dsd = Converter.parseStruct(zipFile, langs);
                List<Series> data = Converter.parseData(zipFile, dsd);
                SdmxRepository sdmxRepository = SdmxRepository.builder().structure(dsd).dataSet(DataSet.builder().ref(Converter.toDataflowRef(productId)).data(data).build()).build();
                return sdmxRepository;
            }
        }

        private static DataStructure parseStruct(ZipFile file, LanguagePriorityList langs) throws IOException {
            Xml.Parser parser = SdmxXmlStreams.struct21((LanguagePriorityList)langs);
            try {
                return (DataStructure)file.stream().filter(Converter::isDataStructure).map(entry -> Converter.asSource(file, entry)).map(IOFunction.unchecked(arg_0 -> ((FileParser)parser).parseStream(arg_0))).flatMap(Collection::stream).findFirst().orElseThrow(() -> new IOException("Missing data structure"));
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }

        private static List<Series> parseData(ZipFile file, DataStructure dsd) throws IOException {
            Xml.Parser parser = SdmxXmlStreams.compactData21((DataStructure)dsd, (ObsFactory)ObsFactories.SDMX21).andThen(IOFunction.unchecked(Converter::toSeries));
            try {
                return ((Stream)file.stream().parallel()).filter(entry -> !Converter.isDataStructure(entry)).map(entry -> Converter.asSource(file, entry)).map(IOFunction.unchecked(arg_0 -> ((FileParser)parser).parseStream(arg_0))).flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }

        private static List<Series> toSeries(DataCursor cursor) throws IOException {
            try {
                List<Series> list = cursor.toStream().collect(Collectors.toList());
                return list;
            }
            finally {
                cursor.close();
            }
        }

        private static boolean isDataStructure(ZipEntry entry) {
            return entry.getName().endsWith("_Structure.xml");
        }

        private static IOSupplier<? extends InputStream> asSource(ZipFile file, ZipEntry entry) {
            return () -> file.getInputStream(entry);
        }

        @Generated
        private Converter() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    @VisibleForTesting
    static class FullTableDownloadSDMX {
        String status;
        URL object;

        static @org.checkerframework.checker.nullness.qual.NonNull FullTableDownloadSDMX parse(@org.checkerframework.checker.nullness.qual.NonNull Reader reader) {
            return (FullTableDownloadSDMX)new Gson().fromJson(reader, FullTableDownloadSDMX.class);
        }

        @Generated
        public FullTableDownloadSDMX() {
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public URL getObject() {
            return this.object;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setObject(URL object) {
            this.object = object;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FullTableDownloadSDMX)) {
                return false;
            }
            FullTableDownloadSDMX other = (FullTableDownloadSDMX)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            URL this$object = this.getObject();
            URL other$object = other.getObject();
            return !(this$object == null ? other$object != null : !((Object)this$object).equals(other$object));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FullTableDownloadSDMX;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            URL $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : ((Object)$object).hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "StatCanDriver.FullTableDownloadSDMX(status=" + this.getStatus() + ", object=" + this.getObject() + ")";
        }
    }

    @VisibleForTesting
    static class DataTable {
        int productId;
        String cubeTitleEn;
        String cubeTitleFr;

        static @org.checkerframework.checker.nullness.qual.NonNull DataTable[] parseAll(@org.checkerframework.checker.nullness.qual.NonNull Reader reader) {
            return (DataTable[])new Gson().fromJson(reader, DataTable[].class);
        }

        @Generated
        DataTable(int productId, String cubeTitleEn, String cubeTitleFr) {
            this.productId = productId;
            this.cubeTitleEn = cubeTitleEn;
            this.cubeTitleFr = cubeTitleFr;
        }

        @Generated
        public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public int getProductId() {
            return this.productId;
        }

        @Generated
        public String getCubeTitleEn() {
            return this.cubeTitleEn;
        }

        @Generated
        public String getCubeTitleFr() {
            return this.cubeTitleFr;
        }

        @Generated
        public void setProductId(int productId) {
            this.productId = productId;
        }

        @Generated
        public void setCubeTitleEn(String cubeTitleEn) {
            this.cubeTitleEn = cubeTitleEn;
        }

        @Generated
        public void setCubeTitleFr(String cubeTitleFr) {
            this.cubeTitleFr = cubeTitleFr;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataTable)) {
                return false;
            }
            DataTable other = (DataTable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProductId() != other.getProductId()) {
                return false;
            }
            String this$cubeTitleEn = this.getCubeTitleEn();
            String other$cubeTitleEn = other.getCubeTitleEn();
            if (this$cubeTitleEn == null ? other$cubeTitleEn != null : !this$cubeTitleEn.equals(other$cubeTitleEn)) {
                return false;
            }
            String this$cubeTitleFr = this.getCubeTitleFr();
            String other$cubeTitleFr = other.getCubeTitleFr();
            return !(this$cubeTitleFr == null ? other$cubeTitleFr != null : !this$cubeTitleFr.equals(other$cubeTitleFr));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof DataTable;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProductId();
            String $cubeTitleEn = this.getCubeTitleEn();
            result = result * 59 + ($cubeTitleEn == null ? 43 : $cubeTitleEn.hashCode());
            String $cubeTitleFr = this.getCubeTitleFr();
            result = result * 59 + ($cubeTitleFr == null ? 43 : $cubeTitleFr.hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "StatCanDriver.DataTable(productId=" + this.getProductId() + ", cubeTitleEn=" + this.getCubeTitleEn() + ", cubeTitleFr=" + this.getCubeTitleFr() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private int productId;
            @Generated
            private String cubeTitleEn;
            @Generated
            private String cubeTitleFr;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder productId(int productId) {
                this.productId = productId;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder cubeTitleEn(String cubeTitleEn) {
                this.cubeTitleEn = cubeTitleEn;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder cubeTitleFr(String cubeTitleFr) {
                this.cubeTitleFr = cubeTitleFr;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull DataTable build() {
                return new DataTable(this.productId, this.cubeTitleEn, this.cubeTitleFr);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "StatCanDriver.DataTable.Builder(productId=" + this.productId + ", cubeTitleEn=" + this.cubeTitleEn + ", cubeTitleFr=" + this.cubeTitleFr + ")";
            }
        }
    }

    @VisibleForTesting
    static class CachedStatCanClient
    implements StatCanClient {
        @NonNull
        private final StatCanClient delegate;
        @NonNull
        private final SdmxCache cache;
        @NonNull
        private final URI base;
        @NonNull
        private final Duration ttl;
        private final AtomicReference<Object> idOfFlows = new AtomicReference();
        private final AtomicReference<Object> idOfRepo = new AtomicReference();

        static @org.checkerframework.checker.nullness.qual.NonNull CachedStatCanClient of(@org.checkerframework.checker.nullness.qual.NonNull StatCanClient client, @org.checkerframework.checker.nullness.qual.NonNull SdmxCache cache, long ttlInMillis, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList languages) {
            return new CachedStatCanClient(client, cache, CachedStatCanClient.getBase(source, languages), Duration.ofMillis(ttlInMillis));
        }

        private static URI getBase(SdmxWebSource source, LanguagePriorityList languages) {
            return TypedId.resolveURI((URI)URI.create("cache:rest"), (String[])new String[]{source.getEndpoint().getHost(), languages.toString()});
        }

        private static TypedId<List<Dataflow>> initIdOfFlows(URI base) {
            return TypedId.of((URI)base, SdmxRepository::getFlows, flows -> SdmxRepository.builder().flows((Collection)flows).build()).with((Object)"flows");
        }

        private static TypedId<SdmxRepository> initIdOfRepo(URI base) {
            return TypedId.of((URI)base, Function.identity(), Function.identity()).with((Object)"structAndData");
        }

        @Override
        public List<Dataflow> getFlows() throws IOException {
            return (List)this.getIdOfFlows().load(this.cache, this.delegate::getFlows, o -> this.ttl);
        }

        @Override
        public SdmxRepository getStructAndData(int productId) throws IOException {
            return (SdmxRepository)this.getIdOfRepo().with((Object)productId).load(this.cache, () -> this.delegate.getStructAndData(productId), o -> this.ttl);
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull Duration ping() throws IOException {
            return this.delegate.ping();
        }

        @Generated
        public CachedStatCanClient(@NonNull StatCanClient delegate, @NonNull SdmxCache cache, @NonNull URI base, @NonNull Duration ttl) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            if (base == null) {
                throw new NullPointerException("base is marked non-null but is null");
            }
            if (ttl == null) {
                throw new NullPointerException("ttl is marked non-null but is null");
            }
            this.delegate = delegate;
            this.cache = cache;
            this.base = base;
            this.ttl = ttl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public TypedId<List<Dataflow>> getIdOfFlows() {
            Object value = this.idOfFlows.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.idOfFlows;
                synchronized (atomicReference) {
                    value = this.idOfFlows.get();
                    if (value == null) {
                        TypedId<List<Dataflow>> actualValue = CachedStatCanClient.initIdOfFlows(this.base);
                        value = actualValue == null ? this.idOfFlows : actualValue;
                        this.idOfFlows.set(value);
                    }
                }
            }
            return (TypedId)(value == this.idOfFlows ? null : value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public TypedId<SdmxRepository> getIdOfRepo() {
            Object value = this.idOfRepo.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.idOfRepo;
                synchronized (atomicReference) {
                    value = this.idOfRepo.get();
                    if (value == null) {
                        TypedId<SdmxRepository> actualValue = CachedStatCanClient.initIdOfRepo(this.base);
                        value = actualValue == null ? this.idOfRepo : actualValue;
                        this.idOfRepo.set(value);
                    }
                }
            }
            return (TypedId)(value == this.idOfRepo ? null : value);
        }
    }

    @VisibleForTesting
    static class DefaultStatCanClient
    implements StatCanClient {
        private final URL endpoint;
        private final LanguagePriorityList langs;
        private final HttpClient client;

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull List<Dataflow> getFlows() throws IOException {
            return Stream.of(this.getAllCubesListLite()).map(dataTable -> Converter.toDataFlow(dataTable, this.langs)).collect(Collectors.toList());
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull SdmxRepository getStructAndData(int productId) throws IOException {
            FullTableDownloadSDMX ref = this.getFullTableDownloadSDMX(productId);
            File downloaded = this.getFullTableDownloadSDMX(ref);
            SdmxRepository result = Converter.toSdmxRepository(downloaded, productId, this.langs);
            if (!downloaded.delete()) {
                throw new IOException("Cannot delete temp file");
            }
            return result;
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull Duration ping() throws IOException {
            Clock clock = Clock.systemDefaultZone();
            Instant start = clock.instant();
            this.getAllCubesListLite();
            return Duration.between(start, clock.instant());
        }

        private DataTable[] getAllCubesListLite() throws IOException {
            HttpRequest request = HttpRequest.builder().query(URLQueryBuilder.of(this.endpoint).path("getAllCubesListLite").build()).mediaType(RiHttpUtils.JSON_TYPE).build();
            try (HttpResponse response = this.client.requestGET(request);){
                DataTable[] dataTableArray;
                block12: {
                    Reader reader = response.getBodyAsReader();
                    try {
                        dataTableArray = DataTable.parseAll(reader);
                        if (reader == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return dataTableArray;
            }
        }

        private FullTableDownloadSDMX getFullTableDownloadSDMX(int productId) throws IOException {
            HttpRequest request = HttpRequest.builder().query(URLQueryBuilder.of(this.endpoint).path("getFullTableDownloadSDMX").path(String.valueOf(productId)).build()).mediaType(RiHttpUtils.JSON_TYPE).build();
            try (HttpResponse response = this.client.requestGET(request);){
                FullTableDownloadSDMX fullTableDownloadSDMX;
                block12: {
                    Reader reader = response.getBodyAsReader();
                    try {
                        fullTableDownloadSDMX = FullTableDownloadSDMX.parse(reader);
                        if (reader == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return fullTableDownloadSDMX;
            }
        }

        private File getFullTableDownloadSDMX(FullTableDownloadSDMX ref) throws IOException {
            HttpRequest request = HttpRequest.builder().query(ref.getObject()).mediaType(RiHttpUtils.ZIP_TYPE).build();
            try (HttpResponse response = this.client.requestGET(request);){
                File file;
                block12: {
                    InputStream stream = response.getBody();
                    try {
                        Path result = Files.createTempFile("fullTable", ".zip", new FileAttribute[0]);
                        Files.copy(stream, result, StandardCopyOption.REPLACE_EXISTING);
                        file = result.toFile();
                        if (stream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return file;
            }
        }

        @Generated
        public DefaultStatCanClient(URL endpoint, LanguagePriorityList langs, HttpClient client) {
            this.endpoint = endpoint;
            this.langs = langs;
            this.client = client;
        }
    }

    @VisibleForTesting
    static interface StatCanClient {
        public @org.checkerframework.checker.nullness.qual.NonNull List<Dataflow> getFlows() throws IOException;

        public @org.checkerframework.checker.nullness.qual.NonNull SdmxRepository getStructAndData(int var1) throws IOException;

        public @org.checkerframework.checker.nullness.qual.NonNull Duration ping() throws IOException;
    }

    private static final class StatCanConnection
    implements SdmxWebConnection {
        @NonNull
        private final String source;
        @NonNull
        private final StatCanClient client;

        public @org.checkerframework.checker.nullness.qual.NonNull Collection<Dataflow> getFlows() throws IOException {
            return this.client.getFlows();
        }

        public @org.checkerframework.checker.nullness.qual.NonNull Dataflow getFlow(@org.checkerframework.checker.nullness.qual.NonNull DataflowRef flowRef) throws IOException {
            return this.getFlows().stream().filter(arg_0 -> ((DataflowRef)flowRef).containsRef(arg_0)).findFirst().orElseThrow(() -> SdmxException.missingFlow((String)this.source, (DataflowRef)flowRef));
        }

        public @org.checkerframework.checker.nullness.qual.NonNull DataStructure getStructure(@org.checkerframework.checker.nullness.qual.NonNull DataflowRef flowRef) throws IOException {
            int productId = Converter.fromDataflowRef(flowRef);
            DataStructureRef dsdRef = Converter.toDataStructureRef(productId);
            return (DataStructure)this.client.getStructAndData(productId).getStructure(dsdRef).orElseThrow(() -> SdmxException.missingStructure((String)this.source, (DataStructureRef)dsdRef));
        }

        private DataSet getDataSet(DataRef dataRef) throws IOException {
            int productId = Converter.fromDataflowRef(dataRef.getFlowRef());
            return (DataSet)this.client.getStructAndData(productId).getDataSet(dataRef.getFlowRef()).orElseThrow(() -> SdmxException.missingData((String)this.source, (DataRef)dataRef));
        }

        public @org.checkerframework.checker.nullness.qual.NonNull Collection<Series> getData(@org.checkerframework.checker.nullness.qual.NonNull DataRef dataRef) throws IOException {
            return this.getDataSet(dataRef).getData(dataRef.getKey(), dataRef.getFilter());
        }

        public @org.checkerframework.checker.nullness.qual.NonNull Stream<Series> getDataStream(@org.checkerframework.checker.nullness.qual.NonNull DataRef dataRef) throws IOException {
            return this.getDataSet(dataRef).getDataStream(dataRef.getKey(), dataRef.getFilter());
        }

        public @org.checkerframework.checker.nullness.qual.NonNull DataCursor getDataCursor(@org.checkerframework.checker.nullness.qual.NonNull DataRef dataRef) throws IOException {
            return this.getDataSet(dataRef).getDataCursor(dataRef.getKey(), dataRef.getFilter());
        }

        public boolean isDetailSupported() {
            return true;
        }

        public @org.checkerframework.checker.nullness.qual.NonNull Duration ping() throws IOException {
            return this.client.ping();
        }

        public @org.checkerframework.checker.nullness.qual.NonNull String getDriver() {
            return StatCanDriver.RI_STATCAN;
        }

        public void close() throws IOException {
        }

        @Generated
        public StatCanConnection(@NonNull String source, @NonNull StatCanClient client) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.source = source;
            this.client = client;
        }
    }
}

