/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import nbbrd.io.text.BooleanProperty;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.DataCursor;
import sdmxdl.DataFilter;
import sdmxdl.DataRef;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.Dimension;
import sdmxdl.Frequency;
import sdmxdl.Key;
import sdmxdl.Obs;
import sdmxdl.Series;
import sdmxdl.ext.SdmxException;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;

public final class RngDriver
implements SdmxWebDriver {
    private static final String RI_RNG = "ri:rng";
    private static final BooleanProperty ENABLE = BooleanProperty.of((String)"enableRngDriver", (boolean)false);

    public @NonNull String getName() {
        return RI_RNG;
    }

    public int getRank() {
        return 127;
    }

    public boolean isAvailable() {
        return ENABLE.get(System.getProperties());
    }

    public @NonNull SdmxWebConnection connect(@NonNull SdmxWebSource source, @NonNull SdmxWebContext context) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(context);
        SdmxRestDriverSupport.checkSource((SdmxWebSource)source, (String)this.getName());
        RngConfig config = RngConfig.parse(source.getEndpoint());
        return new RngWebConnection(source.getId(), config);
    }

    public @NonNull Collection<SdmxWebSource> getDefaultSources() {
        return Collections.singleton(SdmxWebSource.builder().name("RNG").description("Random number generator").driver(RI_RNG).endpointOf("rng:3:4:0:2010-01-01").build());
    }

    public @NonNull Collection<String> getSupportedProperties() {
        return Collections.emptyList();
    }

    private static class RngWebConnection
    implements SdmxWebConnection {
        private static final String FREQ = "FREQ";
        private static final String INDEX = "INDEX";
        private final String name;
        private final RngConfig config;

        public @NonNull Duration ping() {
            return Duration.ZERO;
        }

        public @NonNull String getDriver() {
            return RngDriver.RI_RNG;
        }

        public @NonNull Collection<Dataflow> getFlows() {
            return Collections.singleton(Dataflow.of((DataflowRef)DataflowRef.parse((CharSequence)"RNG"), (DataStructureRef)DataStructureRef.parse((CharSequence)"STRUCT_RNG"), (String)"RNG"));
        }

        public @NonNull Dataflow getFlow(@NonNull DataflowRef flowRef) throws IOException {
            return this.getFlows().stream().filter(arg_0 -> ((DataflowRef)flowRef).containsRef(arg_0)).findFirst().orElseThrow(() -> SdmxException.missingFlow((String)this.name, (DataflowRef)flowRef));
        }

        public @NonNull DataStructure getStructure(@NonNull DataflowRef flowRef) throws IOException {
            Dataflow dataflow = this.getFlow(flowRef);
            return DataStructure.builder().ref(dataflow.getStructureRef()).dimension(Dimension.builder().id(FREQ).label("Frequency").position(1).codelist(Codelist.builder().ref(CodelistRef.parse((CharSequence)"CL_FREQ")).codes(Freq.stream().collect(Collectors.toMap(Enum::name, Freq::getLabel))).build()).build()).dimension(Dimension.builder().id(INDEX).label("Index").position(2).codelist(Codelist.builder().ref(CodelistRef.parse((CharSequence)"CL_INDEX")).codes(IntStream.range(0, this.config.getSeriesCount()).mapToObj(String::valueOf).collect(Collectors.toMap(series -> series, series -> "S" + series))).build()).build()).timeDimensionId("TIME_PERIOD").primaryMeasureId("OBS_VALUE").label("RNG").build();
        }

        public @NonNull Collection<Series> getData(@NonNull DataRef dataRef) {
            return this.getDataStream(dataRef).collect(Collectors.toList());
        }

        public @NonNull Stream<Series> getDataStream(@NonNull DataRef dataRef) {
            return Freq.stream().flatMap(freq -> this.newSeriesStream((Freq)((Object)freq), dataRef));
        }

        private Stream<Series> newSeriesStream(Freq freq, DataRef dataRef) {
            return IntStream.range(0, this.config.getSeriesCount()).mapToObj(series -> Key.of((String[])new String[]{freq.name(), String.valueOf(series)})).filter(arg_0 -> ((Key)dataRef.getKey()).contains(arg_0)).map(key -> this.newSeries((Key)key, freq, dataRef.getFilter().getDetail()));
        }

        private Series newSeries(Key key, Freq freq, DataFilter.Detail detail) {
            Series.Builder result = Series.builder().key(key).freq(freq.getFrequency());
            if (detail.isDataRequested()) {
                int series = Integer.parseInt(key.get(1));
                int obsCount = (int)freq.getUnit().between(this.config.getStart(), this.config.getStart().plusYears(this.config.getYearCount()));
                long startTimeMillis = this.config.getStart().toInstant(ZoneOffset.UTC).toEpochMilli();
                Random random = new Random(this.config.getSeed());
                IntStream.range(0, obsCount).mapToObj(j -> Obs.builder().period(this.config.getStart().plus(j, freq.getUnit())).value(Double.valueOf(this.getValue(series, startTimeMillis, random))).build()).forEach(arg_0 -> ((Series.Builder)result).obs(arg_0));
            }
            return result.build();
        }

        public @NonNull DataCursor getDataCursor(@NonNull DataRef dataRef) {
            return DataCursor.of(this.getDataStream(dataRef).iterator());
        }

        public boolean isDetailSupported() {
            return true;
        }

        public void close() {
        }

        private double getValue(int series, long startTimeMillis, Random random) {
            return Math.round(Math.abs(100.0 * Math.cos(startTimeMillis * (long)series) + 100.0 * (Math.sin(startTimeMillis) - Math.cos(random.nextDouble()) + Math.tan(random.nextDouble()))) - 50.0);
        }

        @Generated
        public RngWebConnection(String name, RngConfig config) {
            this.name = name;
            this.config = config;
        }

        static enum Freq {
            A("Annual", Frequency.ANNUAL, ChronoUnit.YEARS),
            M("Monthly", Frequency.MONTHLY, ChronoUnit.MONTHS),
            D("Daily", Frequency.DAILY, ChronoUnit.DAYS);

            private final String label;
            private final Frequency frequency;
            private final ChronoUnit unit;

            public static Stream<Freq> stream() {
                return Stream.of(Freq.values());
            }

            @Generated
            private Freq(String label, Frequency frequency, ChronoUnit unit) {
                this.label = label;
                this.frequency = frequency;
                this.unit = unit;
            }

            @Generated
            public String getLabel() {
                return this.label;
            }

            @Generated
            public Frequency getFrequency() {
                return this.frequency;
            }

            @Generated
            public ChronoUnit getUnit() {
                return this.unit;
            }
        }
    }

    private static final class RngConfig {
        private final int seriesCount;
        private final int yearCount;
        private final int seed;
        private final LocalDateTime start;
        private static final Parser<Integer> INTEGER_PARSER = Parser.onInteger();
        private static final Parser<LocalDate> LOCAL_DATE_PARSER = Parser.onDateTimeFormatter((DateTimeFormatter)DateTimeFormatter.ISO_DATE, (TemporalQuery[])new TemporalQuery[]{LocalDate::from});

        static RngConfig parse(URI endpoint) throws IllegalArgumentException {
            String[] tmp = endpoint.toString().split(":", -1);
            if (tmp.length != 5) {
                throw new IllegalArgumentException("Invalid uri");
            }
            return new RngConfig(INTEGER_PARSER.parseValue((CharSequence)tmp[1]).orElse(3), INTEGER_PARSER.parseValue((CharSequence)tmp[2]).orElse(4), INTEGER_PARSER.parseValue((CharSequence)tmp[3]).orElse(0), LOCAL_DATE_PARSER.parseValue((CharSequence)tmp[4]).map(LocalDate::atStartOfDay).orElse(LocalDate.of(2010, Month.JANUARY, 1).atStartOfDay()));
        }

        @Generated
        public RngConfig(int seriesCount, int yearCount, int seed, LocalDateTime start) {
            this.seriesCount = seriesCount;
            this.yearCount = yearCount;
            this.seed = seed;
            this.start = start;
        }

        @Generated
        public int getSeriesCount() {
            return this.seriesCount;
        }

        @Generated
        public int getYearCount() {
            return this.yearCount;
        }

        @Generated
        public int getSeed() {
            return this.seed;
        }

        @Generated
        public LocalDateTime getStart() {
            return this.start;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RngConfig)) {
                return false;
            }
            RngConfig other = (RngConfig)o;
            if (this.getSeriesCount() != other.getSeriesCount()) {
                return false;
            }
            if (this.getYearCount() != other.getYearCount()) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            LocalDateTime this$start = this.getStart();
            LocalDateTime other$start = other.getStart();
            return !(this$start == null ? other$start != null : !((Object)this$start).equals(other$start));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSeriesCount();
            result = result * 59 + this.getYearCount();
            result = result * 59 + this.getSeed();
            LocalDateTime $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "RngDriver.RngConfig(seriesCount=" + this.getSeriesCount() + ", yearCount=" + this.getYearCount() + ", seed=" + this.getSeed() + ", start=" + this.getStart() + ")";
        }
    }
}

