/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import internal.sdmxdl.ri.web.DotStatRestParsers;
import internal.sdmxdl.ri.web.DotStatRestQueries;
import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestClient;
import internal.util.http.HttpClient;
import internal.util.http.HttpResponse;
import internal.util.http.HttpResponseException;
import internal.util.http.MediaType;
import internal.util.http.URLQueryBuilder;
import internal.util.http.ext.InterceptingClient;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.ObsFactory;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;

public final class NbbDriver2
implements SdmxWebDriver {
    private static final String RI_NBB = "ri:nbb";
    private final SdmxRestDriverSupport support = SdmxRestDriverSupport.builder().name("ri:nbb").rank(127).client(NbbDriver2::newClient).supportedProperties(RiHttpUtils.CONNECTION_PROPERTIES).source(SdmxWebSource.builder().name("NBB").description("National Bank of Belgium").driver("ri:nbb").endpointOf("https://stat.nbb.be/restsdmx/sdmx.ashx").websiteOf("https://stat.nbb.be").monitorOf("upptime:/nbbrd/sdmx-upptime/NBB").build()).build();
    private static final MediaType HTML_TYPE = new MediaType("text", "html", Collections.emptyMap());
    private static final HttpResponseException SERVICE_UNAVAILABLE = new HttpResponseException(503, "Service unavailable");

    private static RiRestClient newClient(SdmxWebSource s, SdmxWebContext c) throws IOException {
        return NbbDriver2.newClient(s.getId(), s.getEndpoint().toURL(), c.getLanguages(), ObsFactories.getObsFactory((SdmxWebContext)c, (SdmxWebSource)s, (String)"SDMX20"), RiHttpUtils.newClient(s, c));
    }

    @VisibleForTesting
    static @NonNull RiRestClient newClient(@NonNull String name, @NonNull URL endpoint, @NonNull LanguagePriorityList langs, @NonNull ObsFactory obsFactory, @NonNull HttpClient executor) {
        return new RiRestClient(name, endpoint, langs, obsFactory, new InterceptingClient(executor, (client, request, response) -> NbbDriver2.checkInternalErrorRedirect(response)), new NbbQueries(), new DotStatRestParsers(), false);
    }

    static HttpResponse checkInternalErrorRedirect(HttpResponse result) throws IOException {
        if (result.getContentType().isCompatible(HTML_TYPE)) {
            throw SERVICE_UNAVAILABLE;
        }
        return result;
    }

    @Generated
    public boolean isAvailable() {
        return this.support.isAvailable();
    }

    @Generated
    public SdmxWebConnection connect(SdmxWebSource source, SdmxWebContext context) throws IOException {
        return this.support.connect(source, context);
    }

    @Generated
    public Collection<SdmxWebSource> getDefaultSources() {
        return this.support.getDefaultSources();
    }

    @Generated
    public Collection<String> getSupportedProperties() {
        return this.support.getSupportedProperties();
    }

    @Generated
    public SdmxRestDriverSupport.Builder toBuilder() {
        return this.support.toBuilder();
    }

    @Generated
    public String getName() {
        return this.support.getName();
    }

    @Generated
    public int getRank() {
        return this.support.getRank();
    }

    @VisibleForTesting
    static final class NbbQueries
    extends DotStatRestQueries {
        NbbQueries() {
        }

        @Override
        public URLQueryBuilder getDataQuery(URL endpoint, DataRef ref) {
            return URLQueryBuilder.of(endpoint).path("GetData").path(ref.getFlowRef().getId()).path(ref.getKey() + "/all").param("format", "compact_v2");
        }
    }
}

