/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestClient;
import internal.sdmxdl.ri.web.Sdmx21RestParsers;
import internal.sdmxdl.ri.web.Sdmx21RestQueries;
import internal.util.http.MediaType;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.DataCursor;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dimension;
import sdmxdl.ext.ObsFactory;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;

public final class InseeDriver2
implements SdmxWebDriver {
    private static final String RI_INSEE = "ri:insee";
    private final SdmxRestDriverSupport support = SdmxRestDriverSupport.builder().name("ri:insee").rank(127).client(InseeClient::new).supportedProperties(RiHttpUtils.CONNECTION_PROPERTIES).source(SdmxWebSource.builder().name("INSEE").description("Institut national de la statistique et des \u00e9tudes \u00e9conomiques").driver("ri:insee").endpointOf("https://bdm.insee.fr/series/sdmx").websiteOf("https://www.insee.fr/fr/statistiques").monitorOf("upptime:/nbbrd/sdmx-upptime/INSEE").build()).build();
    private static final String DIALECT = "INSEE2017";
    private static final MediaType DATA_TYPE = RiHttpUtils.STRUCTURE_SPECIFIC_DATA_21_TYPE;

    private static Dimension fixDimensionId(Dimension dimension) {
        String id = dimension.getId();
        return dimension.getId().endsWith("6") ? dimension.toBuilder().id(id.substring(0, id.length() - 1)).build() : dimension;
    }

    private static Dimension fixDimensionCodes(Dimension dimension, IOFunction<CodelistRef, Codelist> codelistProvider) throws IOException {
        Codelist codelist = dimension.getCodelist();
        return codelist.getCodes().isEmpty() ? dimension.toBuilder().codelist((Codelist)codelistProvider.applyWithIO((Object)codelist.getRef())).build() : dimension;
    }

    @Generated
    public boolean isAvailable() {
        return this.support.isAvailable();
    }

    @Generated
    public SdmxWebConnection connect(SdmxWebSource source, SdmxWebContext context) throws IOException {
        return this.support.connect(source, context);
    }

    @Generated
    public Collection<SdmxWebSource> getDefaultSources() {
        return this.support.getDefaultSources();
    }

    @Generated
    public Collection<String> getSupportedProperties() {
        return this.support.getSupportedProperties();
    }

    @Generated
    public SdmxRestDriverSupport.Builder toBuilder() {
        return this.support.toBuilder();
    }

    @Generated
    public String getName() {
        return this.support.getName();
    }

    @Generated
    public int getRank() {
        return this.support.getRank();
    }

    private static final class InseeRestParsers
    extends Sdmx21RestParsers {
        private InseeRestParsers() {
        }

        @Override
        public @NonNull FileParser<DataCursor> getDataParser(@NonNull MediaType mediaType, @NonNull DataStructure dsd, @NonNull ObsFactory dataFactory) {
            return super.getDataParser(DATA_TYPE, dsd, dataFactory);
        }
    }

    private static final class InseeClient
    extends RiRestClient {
        InseeClient(SdmxWebSource s, SdmxWebContext c) throws IOException {
            super(s.getId(), s.getEndpoint().toURL(), c.getLanguages(), ObsFactories.getObsFactory((SdmxWebContext)c, (SdmxWebSource)s, (String)InseeDriver2.DIALECT), RiHttpUtils.newClient(s, c), new Sdmx21RestQueries(false), new InseeRestParsers(), true);
        }

        @Override
        public @NonNull DataStructure getStructure(@NonNull DataStructureRef ref) throws IOException {
            DataStructure dsd = super.getStructure(ref);
            DataStructure.Builder result = dsd.toBuilder().clearDimensions();
            for (Dimension dimension : dsd.getDimensions()) {
                result.dimension(InseeDriver2.fixDimensionCodes(InseeDriver2.fixDimensionId(dimension), (IOFunction<CodelistRef, Codelist>)x$0 -> super.getCodelist((CodelistRef)x$0)));
            }
            return result.build();
        }
    }
}

