/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import nbbrd.io.text.Property;
import sdmxdl.DataCursor;
import sdmxdl.DataRef;
import sdmxdl.DataStructure;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.Series;
import sdmxdl.file.SdmxFileConnection;
import sdmxdl.file.SdmxFileListener;
import sdmxdl.file.SdmxFileManager;
import sdmxdl.file.SdmxFileSource;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebListener;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;

public final class FileDriver
implements SdmxWebDriver {
    private final SdmxFileManager fileManager = SdmxFileManager.ofServiceLoader();
    private static final Property<URI> STRUCTURE_PROPERTY = Property.of((String)"structureURL", null, (Parser)Parser.of(text -> URI.create(text.toString())), (Formatter)Formatter.of(Objects::toString));

    public @org.checkerframework.checker.nullness.qual.NonNull String getName() {
        return "ri:file";
    }

    public int getRank() {
        return 127;
    }

    public boolean isAvailable() {
        return true;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull SdmxWebConnection connect(@org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebContext context) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(context, "context");
        SdmxRestDriverSupport.checkSource((SdmxWebSource)source, (String)this.getName());
        return new WebOverFileConnection(this.open(source, context), this.getName());
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Collection<SdmxWebSource> getDefaultSources() {
        return Collections.emptyList();
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Collection<String> getSupportedProperties() {
        return Collections.singletonList(STRUCTURE_PROPERTY.getKey());
    }

    private SdmxFileConnection open(SdmxWebSource source, SdmxWebContext context) throws IOException {
        return this.fileManager.toBuilder().languages(context.getLanguages()).eventListener((SdmxFileListener)new FileOverWebListener(source, context.getEventListener())).cache(context.getCache()).dialects((Collection)context.getDialects()).build().getConnection(FileDriver.toFileSource(source));
    }

    private static SdmxFileSource toFileSource(SdmxWebSource source) throws IOException {
        return SdmxFileSource.builder().data(FileDriver.toFile(source.getEndpoint())).structure(FileDriver.toFile((URI)STRUCTURE_PROPERTY.get(source.getProperties()))).dialect(source.getDialect()).build();
    }

    @VisibleForTesting
    static File toFile(URI endpoint) throws IOException {
        if (endpoint != null) {
            try {
                return new File(endpoint);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid file name: '" + endpoint + "'", ex);
            }
        }
        return null;
    }

    static final class FileOverWebListener
    implements SdmxFileListener {
        @NonNull
        private final SdmxWebSource webSource;
        @NonNull
        private final SdmxWebListener webListener;

        public boolean isEnabled() {
            return this.webListener.isEnabled();
        }

        public void onFileSourceEvent(@org.checkerframework.checker.nullness.qual.NonNull SdmxFileSource source, @org.checkerframework.checker.nullness.qual.NonNull String message) {
            this.webListener.onWebSourceEvent(this.webSource, message);
        }

        @Generated
        public FileOverWebListener(@NonNull SdmxWebSource webSource, @NonNull SdmxWebListener webListener) {
            if (webSource == null) {
                throw new NullPointerException("webSource is marked non-null but is null");
            }
            if (webListener == null) {
                throw new NullPointerException("webListener is marked non-null but is null");
            }
            this.webSource = webSource;
            this.webListener = webListener;
        }
    }

    @VisibleForTesting
    static final class WebOverFileConnection
    implements SdmxWebConnection {
        @NonNull
        private final SdmxFileConnection delegate;
        @NonNull
        private final String driver;

        public @org.checkerframework.checker.nullness.qual.NonNull Duration ping() {
            return Duration.ZERO;
        }

        public @org.checkerframework.checker.nullness.qual.NonNull String getDriver() {
            return this.driver;
        }

        @Generated
        public WebOverFileConnection(@NonNull SdmxFileConnection delegate, @NonNull String driver) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (driver == null) {
                throw new NullPointerException("driver is marked non-null but is null");
            }
            this.delegate = delegate;
            this.driver = driver;
        }

        @Generated
        public Collection<Dataflow> getFlows() throws IOException {
            return this.delegate.getFlows();
        }

        @Generated
        public Dataflow getFlow(DataflowRef arg0) throws IOException {
            return this.delegate.getFlow(arg0);
        }

        @Generated
        public DataStructure getStructure(DataflowRef arg0) throws IOException {
            return this.delegate.getStructure(arg0);
        }

        @Generated
        public Collection<Series> getData(DataRef arg0) throws IOException {
            return this.delegate.getData(arg0);
        }

        @Generated
        public Stream<Series> getDataStream(DataRef arg0) throws IOException {
            return this.delegate.getDataStream(arg0);
        }

        @Generated
        public DataCursor getDataCursor(DataRef arg0) throws IOException {
            return this.delegate.getDataCursor(arg0);
        }

        @Generated
        public boolean isDetailSupported() throws IOException {
            return this.delegate.isDetailSupported();
        }

        @Generated
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

