/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestClient;
import internal.sdmxdl.ri.web.Sdmx21RestParsers;
import internal.sdmxdl.ri.web.Sdmx21RestQueries;
import internal.util.http.HttpClient;
import internal.util.http.HttpContext;
import internal.util.http.HttpRequest;
import internal.util.http.HttpResponse;
import internal.util.http.HttpResponseException;
import internal.util.http.MediaType;
import internal.util.http.URLQueryBuilder;
import internal.util.http.ext.InterceptingClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.text.IntProperty;
import nbbrd.io.text.LongProperty;
import nbbrd.io.text.Parser;
import sdmxdl.DataflowRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ResourceRef;
import sdmxdl.ext.MessageFooter;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.util.web.SdmxRestClient;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;
import sdmxdl.xml.stream.SdmxXmlStreams;

public final class EurostatDriver2
implements SdmxWebDriver {
    public static final IntProperty ASYNC_MAX_RETRIES_PROPERTY = IntProperty.of((String)"asyncMaxRetries", (int)10);
    public static final LongProperty ASYNC_SLEEP_TIME_PROPERTY = LongProperty.of((String)"asyncSleepTime", (long)6000L);
    private static final String RI_EUROSTAT = "ri:estat";
    private final SdmxRestDriverSupport support = SdmxRestDriverSupport.builder().name("ri:estat").rank(127).client(EurostatDriver2::newClient).supportedProperties(RiHttpUtils.CONNECTION_PROPERTIES).supportedPropertyOf((CharSequence)ASYNC_MAX_RETRIES_PROPERTY).supportedPropertyOf((CharSequence)ASYNC_SLEEP_TIME_PROPERTY).source(SdmxWebSource.builder().name("ESTAT").alias("EUROSTAT").description("Eurostat").driver("ri:estat").endpointOf("https://ec.europa.eu/eurostat/SDMX/diss-web/rest").websiteOf("https://ec.europa.eu/eurostat/data/database").monitorOf("upptime:/nbbrd/sdmx-upptime/ESTAT").build()).build();
    private static final MediaType SDMX_GENERIC_XML = MediaType.parse("application/vnd.sdmx.generic+xml; version=2.1");

    private static SdmxRestClient newClient(SdmxWebSource s, SdmxWebContext c) throws IOException {
        return new RiRestClient(s.getId(), s.getEndpoint().toURL(), c.getLanguages(), ObsFactories.getObsFactory((SdmxWebContext)c, (SdmxWebSource)s, (String)"SDMX21"), EurostatDriver2.getHttpClient(s, c), new EurostatRestQueries(), new Sdmx21RestParsers(), false);
    }

    private static InterceptingClient getHttpClient(SdmxWebSource s, SdmxWebContext c) {
        int asyncMaxRetries = ASYNC_MAX_RETRIES_PROPERTY.get(s.getProperties());
        long asyncSleepTime = ASYNC_SLEEP_TIME_PROPERTY.get(s.getProperties());
        return new InterceptingClient(RiHttpUtils.newClient(EurostatDriver2.getContext(s, c)), (client, request, response) -> EurostatDriver2.checkCodesInMessageFooter(client, response, asyncSleepTime, asyncMaxRetries));
    }

    private static HttpContext getContext(SdmxWebSource s, SdmxWebContext c) {
        return EurostatDriver2.fixCompression(RiHttpUtils.newContext(s, c));
    }

    private static DataflowRef fixAgencyId(DataflowRef ref) {
        return DataflowRef.of((String)"ESTAT", (String)ref.getId(), (String)ref.getVersion());
    }

    private static HttpContext fixCompression(HttpContext context) {
        return context.toBuilder().clearDecoders().build();
    }

    private static HttpResponse checkCodesInMessageFooter(HttpClient client, HttpResponse result, long asyncSleepTime, int asyncMaxRetries) throws IOException {
        if (result.getContentType().isCompatible(SDMX_GENERIC_XML)) {
            MessageFooter messageFooter = EurostatDriver2.parseMessageFooter(result);
            Optional<URL> asyncURL = EurostatDriver2.getAsyncURL(messageFooter);
            if (asyncURL.isPresent()) {
                return EurostatDriver2.requestAsync(client, asyncURL.get(), asyncSleepTime, asyncMaxRetries);
            }
            throw EurostatDriver2.getResponseException(messageFooter);
        }
        return result;
    }

    private static MessageFooter parseMessageFooter(HttpResponse result) throws IOException {
        return (MessageFooter)Sdmx21RestParsers.withCharset(SdmxXmlStreams.messageFooter21((LanguagePriorityList)LanguagePriorityList.ANY), result.getContentType().getCharset()).parseStream(result::getBody);
    }

    private static HttpResponseException getResponseException(MessageFooter messageFooter) {
        return new HttpResponseException(messageFooter.getCode(), String.join((CharSequence)System.lineSeparator(), messageFooter.getTexts()));
    }

    private static Optional<URL> getAsyncURL(MessageFooter messageFooter) {
        return messageFooter.getCode() == 413 ? messageFooter.getTexts().stream().map(arg_0 -> ((Parser)Parser.onURL()).parse(arg_0)).filter(Objects::nonNull).findFirst() : Optional.empty();
    }

    private static HttpResponse requestAsync(HttpClient client, URL url, long sleepTimeInMillis, int retries) throws IOException {
        HttpRequest request = RiHttpUtils.newRequest(url, Collections.singletonList(MediaType.ANY_TYPE), LanguagePriorityList.ANY);
        for (int i = 1; i <= retries; ++i) {
            EurostatDriver2.sleep(sleepTimeInMillis);
            try {
                return new AsyncResponse(client.requestGET(request));
            }
            catch (HttpResponseException ex) {
                if (ex.getResponseCode() == 404) continue;
                throw ex;
            }
        }
        throw new IOException("Asynchronous max retries reached");
    }

    private static void sleep(long timeInMillis) throws IOException {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    @Generated
    public boolean isAvailable() {
        return this.support.isAvailable();
    }

    @Generated
    public SdmxWebConnection connect(SdmxWebSource source, SdmxWebContext context) throws IOException {
        return this.support.connect(source, context);
    }

    @Generated
    public Collection<SdmxWebSource> getDefaultSources() {
        return this.support.getDefaultSources();
    }

    @Generated
    public Collection<String> getSupportedProperties() {
        return this.support.getSupportedProperties();
    }

    @Generated
    public SdmxRestDriverSupport.Builder toBuilder() {
        return this.support.toBuilder();
    }

    @Generated
    public String getName() {
        return this.support.getName();
    }

    @Generated
    public int getRank() {
        return this.support.getRank();
    }

    private static final class AsyncResponse
    implements HttpResponse {
        @NonNull
        private final HttpResponse zipResponse;

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull MediaType getContentType() {
            return RiHttpUtils.GENERIC_DATA_21_TYPE;
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.NonNull InputStream getBody() throws IOException {
            ZipInputStream result = new ZipInputStream(this.zipResponse.getBody());
            try {
                result.getNextEntry();
                return result;
            }
            catch (Throwable ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)this.zipResponse);
                throw ex;
            }
        }

        @Override
        public void close() throws IOException {
            this.zipResponse.close();
        }

        @Generated
        public AsyncResponse(@NonNull HttpResponse zipResponse) {
            if (zipResponse == null) {
                throw new NullPointerException("zipResponse is marked non-null but is null");
            }
            this.zipResponse = zipResponse;
        }
    }

    private static final class EurostatRestQueries
    extends Sdmx21RestQueries {
        public EurostatRestQueries() {
            super(false);
        }

        @Override
        public URLQueryBuilder getFlowsQuery(URL endpoint) {
            return this.onMeta(endpoint, "dataflow", (ResourceRef<?>)EurostatDriver2.fixAgencyId(EurostatRestQueries.FLOWS));
        }

        @Override
        public URLQueryBuilder getFlowQuery(URL endpoint, DataflowRef ref) {
            return super.getFlowQuery(endpoint, EurostatDriver2.fixAgencyId(ref));
        }
    }
}

