/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.drivers;

import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestClient;
import internal.sdmxdl.ri.web.Sdmx21RestParsers;
import internal.sdmxdl.ri.web.Sdmx21RestQueries;
import internal.util.http.URLQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import nbbrd.design.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.DataCursor;
import sdmxdl.DataFilter;
import sdmxdl.DataRef;
import sdmxdl.DataStructure;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.ResourceRef;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.ObsParser;
import sdmxdl.util.parser.DefaultObsParser;
import sdmxdl.util.parser.DefaultObsParserResource;
import sdmxdl.util.parser.FreqFactory;
import sdmxdl.util.web.SdmxRestDriverSupport;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;

public final class BbkDriver
implements SdmxWebDriver {
    private static final String RI_BBK = "ri:bbk";
    private final SdmxRestDriverSupport support = SdmxRestDriverSupport.builder().name("ri:bbk").rank(127).client(BbkClient::new).supportedProperties(RiHttpUtils.CONNECTION_PROPERTIES).source(SdmxWebSource.builder().name("BBK").description("Bundesbank").driver("ri:bbk").endpointOf("https://api.statistiken.bundesbank.de/rest").websiteOf("https://www.bundesbank.de/en/statistics/time-series-databases").monitorOf("upptime:/nbbrd/sdmx-upptime/BBK").build()).build();

    @Generated
    public boolean isAvailable() {
        return this.support.isAvailable();
    }

    @Generated
    public SdmxWebConnection connect(SdmxWebSource source, SdmxWebContext context) throws IOException {
        return this.support.connect(source, context);
    }

    @Generated
    public Collection<SdmxWebSource> getDefaultSources() {
        return this.support.getDefaultSources();
    }

    @Generated
    public Collection<String> getSupportedProperties() {
        return this.support.getSupportedProperties();
    }

    @Generated
    public SdmxRestDriverSupport.Builder toBuilder() {
        return this.support.toBuilder();
    }

    @Generated
    public String getName() {
        return this.support.getName();
    }

    @Generated
    public int getRank() {
        return this.support.getRank();
    }

    private static final class BbkObsFactory
    implements ObsFactory {
        private BbkObsFactory() {
        }

        public @NonNull ObsParser getObsParser(@NonNull DataStructure dsd) {
            Objects.requireNonNull(dsd);
            return DefaultObsParser.builder().freqFactory((DefaultObsParserResource)FreqFactory.sdmx20((DataStructure)dsd)).build();
        }
    }

    @VisibleForTesting
    static final class BbkQueries
    extends Sdmx21RestQueries {
        private static final String AGENCY_ID = "BBK";

        BbkQueries() {
            super(false);
        }

        private static boolean isValid(ResourceRef<?> ref) {
            return !ref.getId().equals("all");
        }

        @Override
        protected URLQueryBuilder onMeta(URL endpoint, String resourcePath, ResourceRef<?> ref) {
            URLQueryBuilder result = URLQueryBuilder.of(endpoint).path("metadata").path(resourcePath).path(AGENCY_ID);
            if (BbkQueries.isValid(ref)) {
                result.path(ref.getId());
            }
            return result;
        }

        @Override
        protected URLQueryBuilder onData(URL endpoint, String resourcePath, DataflowRef flowRef, Key key, String providerRef) {
            return URLQueryBuilder.of(endpoint).path(resourcePath).path(flowRef.getId()).path(key.toString());
        }

        @Override
        protected void applyFilter(DataFilter filter, URLQueryBuilder result) {
            if (filter.getDetail().equals((Object)DataFilter.Detail.SERIES_KEYS_ONLY)) {
                result.param("detail", "serieskeyonly");
            } else {
                super.applyFilter(filter, result);
            }
        }
    }

    @VisibleForTesting
    static final class BbkClient
    extends RiRestClient {
        BbkClient(SdmxWebSource s, SdmxWebContext c) throws IOException {
            super(s.getId(), s.getEndpoint().toURL(), c.getLanguages(), new BbkObsFactory(), RiHttpUtils.newClient(s, c), new BbkQueries(), new Sdmx21RestParsers(), true);
        }

        @Override
        public @NonNull DataCursor getData(@NonNull DataRef ref, @NonNull DataStructure dsd) throws IOException {
            return super.getData(this.fixDataRef(ref, dsd), dsd);
        }

        private DataRef fixDataRef(DataRef ref, DataStructure dsd) {
            return ref.getKey().equals((Object)Key.ALL) ? DataRef.of((DataflowRef)ref.getFlowRef(), (Key)this.alternateAllOf(dsd), (DataFilter)ref.getFilter()) : ref;
        }

        private Key alternateAllOf(DataStructure dsd) {
            return Key.of((String[])new String[dsd.getDimensions().size()]);
        }
    }
}

