/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web.authenticators;

import internal.util.credentials.WinPasswordVault;
import java.io.IOException;
import java.net.PasswordAuthentication;
import nbbrd.io.sys.OS;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebAuthenticator;

public final class WinPasswordVaultAuthenticator
implements SdmxWebAuthenticator {
    public boolean isAvailable() {
        return OS.NAME.equals((Object)OS.Name.WINDOWS);
    }

    public PasswordAuthentication getPasswordAuthentication(SdmxWebSource source) throws IOException {
        try (WinPasswordVault vault = WinPasswordVault.open();){
            String message = "Enter your credentials for " + source.getName();
            PasswordAuthentication passwordAuthentication = this.toPasswordAuthentication(vault.getOrPrompt(this.getResource(source), message, false));
            return passwordAuthentication;
        }
    }

    public void invalidate(SdmxWebSource source) throws IOException {
        try (WinPasswordVault vault = WinPasswordVault.open();){
            vault.invalidate(this.getResource(source));
        }
    }

    private String getResource(SdmxWebSource source) {
        return "sdmx-dl:" + source.getEndpoint().getHost();
    }

    private PasswordAuthentication toPasswordAuthentication(WinPasswordVault.PasswordCredential credential) {
        return credential != null ? new PasswordAuthentication(credential.getUserName(), credential.getPassword()) : null;
    }
}

