/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web;

import internal.sdmxdl.ri.web.RiRestQueries;
import internal.util.http.URLQueryBuilder;
import java.net.URL;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.CodelistRef;
import sdmxdl.DataFilter;
import sdmxdl.DataRef;
import sdmxdl.DataStructureRef;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.ResourceRef;

public class Sdmx21RestQueries
implements RiRestQueries {
    private final boolean trailingSlashRequired;
    protected static final String DEFAULT_DATAFLOW_PATH = "dataflow";
    protected static final String DEFAULT_DATASTRUCTURE_PATH = "datastructure";
    protected static final String DEFAULT_DATA_PATH = "data";
    protected static final String DEFAULT_CODELIST_PATH = "codelist";
    protected static final String DEFAULT_PROVIDER_REF = "all";
    protected static final String REFERENCES_PARAM = "references";
    protected static final String DETAIL_PARAM = "detail";
    protected static final DataflowRef FLOWS = DataflowRef.of((String)"all", (String)"all", (String)"latest");

    @Override
    public URLQueryBuilder getFlowsQuery(URL endpoint) {
        return this.onMeta(endpoint, DEFAULT_DATAFLOW_PATH, (ResourceRef<?>)FLOWS).trailingSlash(this.trailingSlashRequired);
    }

    @Override
    public URLQueryBuilder getFlowQuery(URL endpoint, DataflowRef ref) {
        return this.onMeta(endpoint, DEFAULT_DATAFLOW_PATH, (ResourceRef<?>)ref).trailingSlash(this.trailingSlashRequired);
    }

    @Override
    public URLQueryBuilder getStructureQuery(URL endpoint, DataStructureRef ref) {
        return this.onMeta(endpoint, DEFAULT_DATASTRUCTURE_PATH, (ResourceRef<?>)ref).param(REFERENCES_PARAM, "children").trailingSlash(this.trailingSlashRequired);
    }

    @Override
    public URLQueryBuilder getDataQuery(URL endpoint, DataRef ref) {
        URLQueryBuilder result = this.onData(endpoint, DEFAULT_DATA_PATH, ref.getFlowRef(), ref.getKey(), DEFAULT_PROVIDER_REF);
        this.applyFilter(ref.getFilter(), result);
        return result.trailingSlash(this.trailingSlashRequired);
    }

    @Override
    public @NonNull URLQueryBuilder getCodelistQuery(@NonNull URL endpoint, @NonNull CodelistRef ref) {
        return this.onMeta(endpoint, DEFAULT_CODELIST_PATH, (ResourceRef<?>)ref).trailingSlash(this.trailingSlashRequired);
    }

    @Override
    public DataStructureRef peekStructureRef(DataflowRef ref) {
        return null;
    }

    protected void applyFilter(DataFilter filter, URLQueryBuilder result) {
        switch (filter.getDetail()) {
            case SERIES_KEYS_ONLY: {
                result.param(DETAIL_PARAM, "serieskeysonly");
                break;
            }
            case DATA_ONLY: {
                result.param(DETAIL_PARAM, "dataonly");
                break;
            }
            case NO_DATA: {
                result.param(DETAIL_PARAM, "nodata");
            }
        }
    }

    protected URLQueryBuilder onMeta(URL endpoint, String resourcePath, ResourceRef<?> ref) {
        return URLQueryBuilder.of(endpoint).path(resourcePath).path(ref.getAgency()).path(ref.getId()).path(ref.getVersion());
    }

    protected URLQueryBuilder onData(URL endpoint, String resourcePath, DataflowRef flowRef, Key key, String providerRef) {
        return URLQueryBuilder.of(endpoint).path(resourcePath).path(flowRef.toString()).path(key.toString()).path(providerRef);
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public Sdmx21RestQueries(boolean trailingSlashRequired) {
        this.trailingSlashRequired = trailingSlashRequired;
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean trailingSlashRequired;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder trailingSlashRequired(boolean trailingSlashRequired) {
            this.trailingSlashRequired = trailingSlashRequired;
            return this;
        }

        @Generated
        public @NonNull Sdmx21RestQueries build() {
            return new Sdmx21RestQueries(this.trailingSlashRequired);
        }

        @Generated
        public @NonNull String toString() {
            return "Sdmx21RestQueries.Builder(trailingSlashRequired=" + this.trailingSlashRequired + ")";
        }
    }
}

