/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web;

import internal.sdmxdl.ri.web.FileOverTextParser;
import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestParsers;
import internal.util.http.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.FileParser;
import nbbrd.io.xml.Xml;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.DataCursor;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.ObsFactory;
import sdmxdl.xml.stream.SdmxXmlStreams;

public class Sdmx21RestParsers
implements RiRestParsers {
    @VisibleForTesting
    static final List<MediaType> DEFAULT_DATA_TYPES = Arrays.asList(RiHttpUtils.GENERIC_DATA_21_TYPE, RiHttpUtils.STRUCTURE_SPECIFIC_DATA_21_TYPE);
    @VisibleForTesting
    static final List<MediaType> DEFAULT_DATAFLOW_TYPES = Collections.singletonList(RiHttpUtils.STRUCTURE_21_TYPE);
    @VisibleForTesting
    static final List<MediaType> DEFAULT_DATASTRUCTURE_TYPES = Collections.singletonList(RiHttpUtils.STRUCTURE_21_TYPE);

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull List<MediaType> getFlowsTypes() {
        return DEFAULT_DATAFLOW_TYPES;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull FileParser<List<Dataflow>> getFlowsParser(@org.checkerframework.checker.nullness.qual.NonNull MediaType mediaType, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList langs) {
        if (mediaType.isCompatibleWithoutParameters(RiHttpUtils.STRUCTURE_21_TYPE) || mediaType.isCompatible(RiHttpUtils.GENERIC_XML_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.flow21((LanguagePriorityList)langs), mediaType.getCharset());
        }
        return new UnsupportedParser<List<Dataflow>>(mediaType);
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull List<MediaType> getFlowTypes() {
        return DEFAULT_DATAFLOW_TYPES;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull FileParser<Optional<Dataflow>> getFlowParser(@org.checkerframework.checker.nullness.qual.NonNull MediaType mediaType, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList langs, @org.checkerframework.checker.nullness.qual.NonNull DataflowRef ref) {
        if (mediaType.isCompatibleWithoutParameters(RiHttpUtils.STRUCTURE_21_TYPE) || mediaType.isCompatible(RiHttpUtils.GENERIC_XML_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.flow21((LanguagePriorityList)langs).andThen(RiRestParsers.getResourceSelector(ref)), mediaType.getCharset());
        }
        return new UnsupportedParser<Optional<Dataflow>>(mediaType);
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull List<MediaType> getStructureTypes() {
        return DEFAULT_DATASTRUCTURE_TYPES;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull FileParser<Optional<DataStructure>> getStructureParser(@org.checkerframework.checker.nullness.qual.NonNull MediaType mediaType, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList langs, @org.checkerframework.checker.nullness.qual.NonNull DataStructureRef ref) {
        if (mediaType.isCompatibleWithoutParameters(RiHttpUtils.STRUCTURE_21_TYPE) || mediaType.isCompatible(RiHttpUtils.GENERIC_XML_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.struct21((LanguagePriorityList)langs).andThen(RiRestParsers.getResourceSelector(ref)), mediaType.getCharset());
        }
        return new UnsupportedParser<Optional<DataStructure>>(mediaType);
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull List<MediaType> getDataTypes() {
        return DEFAULT_DATA_TYPES;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull FileParser<DataCursor> getDataParser(@org.checkerframework.checker.nullness.qual.NonNull MediaType mediaType, @org.checkerframework.checker.nullness.qual.NonNull DataStructure dsd, @org.checkerframework.checker.nullness.qual.NonNull ObsFactory dataFactory) {
        if (mediaType.isCompatibleWithoutParameters(RiHttpUtils.GENERIC_DATA_21_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.genericData21((DataStructure)dsd, (ObsFactory)dataFactory), mediaType.getCharset());
        }
        if (mediaType.isCompatibleWithoutParameters(RiHttpUtils.STRUCTURE_SPECIFIC_DATA_21_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.compactData21((DataStructure)dsd, (ObsFactory)dataFactory), mediaType.getCharset());
        }
        if (mediaType.isCompatible(RiHttpUtils.GENERIC_XML_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.genericData21((DataStructure)dsd, (ObsFactory)dataFactory), mediaType.getCharset());
        }
        return new UnsupportedParser<DataCursor>(mediaType);
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull List<MediaType> getCodelistTypes() {
        return DEFAULT_DATASTRUCTURE_TYPES;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.NonNull FileParser<Optional<Codelist>> getCodelistParser(@org.checkerframework.checker.nullness.qual.NonNull MediaType mediaType, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList langs, @org.checkerframework.checker.nullness.qual.NonNull CodelistRef ref) {
        if (mediaType.isCompatibleWithoutParameters(RiHttpUtils.STRUCTURE_21_TYPE) || mediaType.isCompatible(RiHttpUtils.GENERIC_XML_TYPE)) {
            return Sdmx21RestParsers.withCharset(SdmxXmlStreams.codelist21((LanguagePriorityList)langs).andThen(RiRestParsers.getResourceSelector(ref)), mediaType.getCharset());
        }
        return new UnsupportedParser<Optional<Codelist>>(mediaType);
    }

    public static <T> FileParser<T> withCharset(Xml.Parser<T> parser, Optional<Charset> charset) {
        return charset.isPresent() ? new FileOverTextParser<T>(parser, charset.get()) : parser;
    }

    @VisibleForTesting
    static final class UnsupportedParser<T>
    implements FileParser<T> {
        @NonNull
        private final MediaType mediaType;

        public @org.checkerframework.checker.nullness.qual.NonNull T parseStream(@org.checkerframework.checker.nullness.qual.NonNull InputStream resource) throws IOException {
            throw new IOException("Unsupported media type '" + this.mediaType + "'");
        }

        public <V> @org.checkerframework.checker.nullness.qual.NonNull FileParser<V> andThen(@org.checkerframework.checker.nullness.qual.NonNull Function<? super T, ? extends V> after) {
            return new UnsupportedParser<T>(this.mediaType);
        }

        @Generated
        public UnsupportedParser(@NonNull MediaType mediaType) {
            if (mediaType == null) {
                throw new NullPointerException("mediaType is marked non-null but is null");
            }
            this.mediaType = mediaType;
        }
    }
}

