/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web;

import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestParsers;
import internal.sdmxdl.ri.web.RiRestQueries;
import internal.util.http.HttpClient;
import internal.util.http.HttpRequest;
import internal.util.http.HttpResponse;
import internal.util.http.HttpResponseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nbbrd.io.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.DataCursor;
import sdmxdl.DataRef;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.ObsFactory;
import sdmxdl.ext.SdmxException;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.util.web.SdmxRestClient;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;

public class RiRestClient
implements SdmxRestClient {
    protected final String name;
    protected final URL endpoint;
    protected final LanguagePriorityList langs;
    protected final ObsFactory obsFactory;
    protected final HttpClient httpClient;
    protected final RiRestQueries queries;
    protected final RiRestParsers parsers;
    protected final boolean detailSupported;

    public static @NonNull RiRestClient of(@NonNull SdmxWebSource s, @NonNull SdmxWebContext c, @NonNull String defaultDialect, @NonNull RiRestQueries queries, @NonNull RiRestParsers parsers, boolean detailSupported) throws IOException {
        return new RiRestClient(s.getId(), s.getEndpoint().toURL(), c.getLanguages(), ObsFactories.getObsFactory((SdmxWebContext)c, (SdmxWebSource)s, (String)defaultDialect), RiHttpUtils.newClient(s, c), queries, parsers, detailSupported);
    }

    public @NonNull List<Dataflow> getFlows() throws IOException {
        return this.getFlows(this.getFlowsQuery());
    }

    public @NonNull Dataflow getFlow(@NonNull DataflowRef ref) throws IOException {
        return this.getFlow(this.getFlowQuery(ref), ref);
    }

    public @NonNull DataStructure getStructure(@NonNull DataStructureRef ref) throws IOException {
        return this.getStructure(this.getStructureQuery(ref), ref);
    }

    public @NonNull DataCursor getData(@NonNull DataRef ref, @NonNull DataStructure dsd) throws IOException {
        return this.getData(this.getDataQuery(ref), dsd);
    }

    public @NonNull Codelist getCodelist(@NonNull CodelistRef ref) throws IOException {
        return this.getCodelist(this.getCodelistQuery(ref), ref);
    }

    public boolean isDetailSupported() {
        return this.detailSupported;
    }

    public DataStructureRef peekStructureRef(@NonNull DataflowRef flowRef) {
        return this.queries.peekStructureRef(flowRef);
    }

    public @NonNull Duration ping() throws IOException {
        Clock clock = Clock.systemDefaultZone();
        Instant start = clock.instant();
        this.getFlows();
        return Duration.between(start, clock.instant());
    }

    protected @NonNull URL getFlowsQuery() throws IOException {
        return this.queries.getFlowsQuery(this.endpoint).build();
    }

    protected @NonNull List<Dataflow> getFlows(@NonNull URL url) throws IOException {
        HttpRequest request = RiHttpUtils.newRequest(url, this.parsers.getFlowsTypes(), this.langs);
        try (HttpResponse response = this.httpClient.requestGET(request);){
            List list = (List)this.parsers.getFlowsParser(response.getContentType(), this.langs).parseStream(response::getBody);
            return list;
        }
    }

    protected @NonNull URL getFlowQuery(@NonNull DataflowRef ref) throws IOException {
        return this.queries.getFlowQuery(this.endpoint, ref).build();
    }

    protected @NonNull Dataflow getFlow(@NonNull URL url, @NonNull DataflowRef ref) throws IOException {
        Dataflow dataflow;
        block9: {
            HttpRequest request = RiHttpUtils.newRequest(url, this.parsers.getFlowTypes(), this.langs);
            HttpResponse response = this.httpClient.requestGET(request);
            try {
                dataflow = (Dataflow)((Optional)this.parsers.getFlowParser(response.getContentType(), this.langs, ref).parseStream(response::getBody)).orElseThrow(() -> SdmxException.missingFlow((String)this.name, (DataflowRef)ref));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpResponseException ex) {
                    if (ex.getResponseCode() == 404) {
                        throw SdmxException.missingFlow((String)this.getName(), (DataflowRef)ref);
                    }
                    throw ex;
                }
            }
            response.close();
        }
        return dataflow;
    }

    protected @NonNull URL getStructureQuery(@NonNull DataStructureRef ref) throws IOException {
        return this.queries.getStructureQuery(this.endpoint, ref).build();
    }

    protected @NonNull DataStructure getStructure(@NonNull URL url, @NonNull DataStructureRef ref) throws IOException {
        DataStructure dataStructure;
        block9: {
            HttpRequest request = RiHttpUtils.newRequest(url, this.parsers.getStructureTypes(), this.langs);
            HttpResponse response = this.httpClient.requestGET(request);
            try {
                dataStructure = (DataStructure)((Optional)this.parsers.getStructureParser(response.getContentType(), this.langs, ref).parseStream(response::getBody)).orElseThrow(() -> SdmxException.missingStructure((String)this.name, (DataStructureRef)ref));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpResponseException ex) {
                    if (ex.getResponseCode() == 404) {
                        throw SdmxException.missingStructure((String)this.getName(), (DataStructureRef)ref);
                    }
                    throw ex;
                }
            }
            response.close();
        }
        return dataStructure;
    }

    protected @NonNull URL getDataQuery(@NonNull DataRef ref) throws IOException {
        return this.queries.getDataQuery(this.endpoint, ref).build();
    }

    protected @NonNull DataCursor getData(@NonNull URL url, @NonNull DataStructure dsd) throws IOException {
        HttpRequest request = RiHttpUtils.newRequest(url, this.parsers.getDataTypes(), this.langs);
        HttpResponse response = this.httpClient.requestGET(request);
        return (DataCursor)this.parsers.getDataParser(response.getContentType(), dsd, this.obsFactory).parseStream(() -> DisconnectingInputStream.of(response));
    }

    protected @NonNull URL getCodelistQuery(@NonNull CodelistRef ref) throws IOException {
        return this.queries.getCodelistQuery(this.endpoint, ref).build();
    }

    protected @NonNull Codelist getCodelist(@NonNull URL url, @NonNull CodelistRef ref) throws IOException {
        Codelist codelist;
        block9: {
            HttpRequest request = RiHttpUtils.newRequest(url, this.parsers.getCodelistTypes(), this.langs);
            HttpResponse response = this.httpClient.requestGET(request);
            try {
                codelist = (Codelist)((Optional)this.parsers.getCodelistParser(response.getContentType(), this.langs, ref).parseStream(response::getBody)).orElseThrow(() -> SdmxException.missingCodelist((String)this.name, (CodelistRef)ref));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpResponseException ex) {
                    if (ex.getResponseCode() == 404) {
                        throw SdmxException.missingCodelist((String)this.getName(), (CodelistRef)ref);
                    }
                    throw ex;
                }
            }
            response.close();
        }
        return codelist;
    }

    @Generated
    public RiRestClient(String name, URL endpoint, LanguagePriorityList langs, ObsFactory obsFactory, HttpClient httpClient, RiRestQueries queries, RiRestParsers parsers, boolean detailSupported) {
        this.name = name;
        this.endpoint = endpoint;
        this.langs = langs;
        this.obsFactory = obsFactory;
        this.httpClient = httpClient;
        this.queries = queries;
        this.parsers = parsers;
        this.detailSupported = detailSupported;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    private static final class DisconnectingInputStream
    extends InputStream {
        private final InputStream delegate;
        private final Closeable onClose;

        public static DisconnectingInputStream of(HttpResponse response) throws IOException {
            return new DisconnectingInputStream(response.getBody(), response);
        }

        @Override
        public void close() throws IOException {
            Resource.closeBoth((Closeable)this.delegate, (Closeable)this.onClose);
        }

        @Generated
        public DisconnectingInputStream(InputStream delegate, Closeable onClose) {
            this.delegate = delegate;
            this.onClose = onClose;
        }

        @Override
        @Generated
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        @Generated
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        @Generated
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        @Generated
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        @Generated
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        @Generated
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        @Generated
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        @Generated
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        @Generated
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        @Generated
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        @Generated
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        @Generated
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }
    }
}

