/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web;

import internal.util.http.DefaultHttpClient;
import internal.util.http.HttpAuthScheme;
import internal.util.http.HttpAuthenticator;
import internal.util.http.HttpClient;
import internal.util.http.HttpContext;
import internal.util.http.HttpEventListener;
import internal.util.http.HttpRequest;
import internal.util.http.HttpURLConnectionFactoryLoader;
import internal.util.http.MediaType;
import internal.util.http.ext.DumpingClient;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.text.BaseProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import nbbrd.io.text.Property;
import org.checkerframework.checker.nullness.qual.Nullable;
import sdmxdl.About;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.NetworkFactory;
import sdmxdl.util.web.SdmxWebEvents;
import sdmxdl.util.web.SdmxWebProperty;
import sdmxdl.web.SdmxWebListener;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebAuthenticator;
import sdmxdl.web.spi.SdmxWebContext;

public final class RiHttpUtils {
    public static final List<String> CONNECTION_PROPERTIES = BaseProperty.keysOf((BaseProperty[])new BaseProperty[]{SdmxWebProperty.CONNECT_TIMEOUT_PROPERTY, SdmxWebProperty.READ_TIMEOUT_PROPERTY, SdmxWebProperty.MAX_REDIRECTS_PROPERTY, SdmxWebProperty.PREEMPTIVE_AUTHENTICATION_PROPERTY});
    public static final MediaType GENERIC_XML_TYPE = MediaType.parse("application/xml");
    public static final MediaType STRUCTURE_21_TYPE = MediaType.parse("application/vnd.sdmx.structure+xml;version=2.1");
    public static final MediaType GENERIC_DATA_21_TYPE = MediaType.parse("application/vnd.sdmx.genericdata+xml;version=2.1");
    public static final MediaType STRUCTURE_SPECIFIC_DATA_21_TYPE = MediaType.parse("application/vnd.sdmx.structurespecificdata+xml;version=2.1");
    public static final MediaType STRUCTURE_SPECIFIC_DATA_20_TYPE = MediaType.parse("application/vnd.sdmx.structurespecificdata+xml;version=2.0");
    public static final MediaType JSON_TYPE = MediaType.parse("application/json");
    public static final MediaType ZIP_TYPE = MediaType.parse("application/zip");
    @VisibleForTesting
    static final Property<File> SDMXDL_RI_WEB_DUMP_FOLDER_PROPERTY = Property.of((String)"sdmxdl.ri.web.dump.folder", null, (Parser)Parser.onFile(), (Formatter)Formatter.onFile());
    @VisibleForTesting
    static final Property<String> HTTP_AGENT = Property.of((String)"http.agent", (Object)("sdmx-dl/" + About.VERSION), (Parser)Parser.onString(), (Formatter)Formatter.onString());

    public static @org.checkerframework.checker.nullness.qual.NonNull HttpRequest newRequest(@org.checkerframework.checker.nullness.qual.NonNull URL query, @org.checkerframework.checker.nullness.qual.NonNull List<MediaType> mediaTypes, @org.checkerframework.checker.nullness.qual.NonNull LanguagePriorityList langs) {
        return HttpRequest.builder().query(query).mediaTypes(mediaTypes).langs(langs.toString()).build();
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull HttpClient newClient(@org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebContext context) {
        return RiHttpUtils.newClient(RiHttpUtils.newContext(source, context));
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull HttpClient newClient(@org.checkerframework.checker.nullness.qual.NonNull HttpContext context) {
        DefaultHttpClient result = new DefaultHttpClient(context, HttpURLConnectionFactoryLoader.get());
        File dumpFile = (File)SDMXDL_RI_WEB_DUMP_FOLDER_PROPERTY.get(System.getProperties());
        return dumpFile != null ? RiHttpUtils.newDumpingClient(context, result, dumpFile) : result;
    }

    private static DumpingClient newDumpingClient(HttpContext context, HttpClient client, File dumpFile) {
        return new DumpingClient(dumpFile.toPath(), client, file -> context.getListener().onEvent("Dumping '" + file + "'"));
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull HttpContext newContext(@org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull SdmxWebContext context) {
        return HttpContext.builder().readTimeout(SdmxWebProperty.READ_TIMEOUT_PROPERTY.get(source.getProperties())).connectTimeout(SdmxWebProperty.CONNECT_TIMEOUT_PROPERTY.get(source.getProperties())).maxRedirects(SdmxWebProperty.MAX_REDIRECTS_PROPERTY.get(source.getProperties())).preemptiveAuthentication(SdmxWebProperty.PREEMPTIVE_AUTHENTICATION_PROPERTY.get(source.getProperties())).proxySelector(() -> ((NetworkFactory)context.getNetwork()).getProxySelector()).sslSocketFactory(() -> ((NetworkFactory)context.getNetwork()).getSslSocketFactory()).hostnameVerifier(() -> ((NetworkFactory)context.getNetwork()).getHostnameVerifier()).listener(new RiHttpEventListener(source, context.getEventListener())).authenticator(new RiHttpAuthenticator(source, context.getAuthenticators(), context.getEventListener())).userAgent((String)HTTP_AGENT.get(System.getProperties())).build();
    }

    @Generated
    private RiHttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class RiHttpAuthenticator
    implements HttpAuthenticator {
        @NonNull
        private final SdmxWebSource source;
        @NonNull
        private final List<SdmxWebAuthenticator> authenticators;
        @NonNull
        private final SdmxWebListener listener;

        @Override
        public @Nullable PasswordAuthentication getPasswordAuthentication(URL url) {
            if (this.isDifferentAuthScope(url)) {
                return null;
            }
            return this.authenticators.stream().map(this::getPasswordAuthentication).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public void invalidate(@org.checkerframework.checker.nullness.qual.NonNull URL url) {
            if (this.isDifferentAuthScope(url)) {
                return;
            }
            this.authenticators.forEach(this::invalidate);
        }

        private boolean isDifferentAuthScope(URL url) {
            return !url.getHost().equals(this.source.getEndpoint().getHost()) || url.getPort() != this.source.getEndpoint().getPort();
        }

        private PasswordAuthentication getPasswordAuthentication(SdmxWebAuthenticator authenticator) {
            try {
                return authenticator.getPasswordAuthentication(this.source);
            }
            catch (IOException ex) {
                this.listener.onWebSourceEvent(this.source, "Failed to get password authentication: " + ex.getMessage());
                return null;
            }
        }

        private void invalidate(SdmxWebAuthenticator authenticator) {
            try {
                authenticator.invalidate(this.source);
            }
            catch (IOException ex) {
                this.listener.onWebSourceEvent(this.source, "Failed to invalidate password authentication: " + ex.getMessage());
            }
        }

        @Generated
        public RiHttpAuthenticator(@NonNull SdmxWebSource source, @NonNull List<SdmxWebAuthenticator> authenticators, @NonNull SdmxWebListener listener) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (authenticators == null) {
                throw new NullPointerException("authenticators is marked non-null but is null");
            }
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.source = source;
            this.authenticators = authenticators;
            this.listener = listener;
        }
    }

    private static final class RiHttpEventListener
    implements HttpEventListener {
        @NonNull
        private final SdmxWebSource source;
        @NonNull
        private final SdmxWebListener listener;

        @Override
        public void onOpen(HttpRequest request, Proxy proxy, HttpAuthScheme scheme) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(proxy);
            Objects.requireNonNull(scheme);
            if (this.listener.isEnabled()) {
                String message = SdmxWebEvents.onQuery((URL)request.getQuery(), (Proxy)proxy);
                if (!HttpAuthScheme.NONE.equals((Object)scheme)) {
                    message = message + " with auth '" + scheme.name() + "'";
                }
                this.listener.onWebSourceEvent(this.source, message);
            }
        }

        @Override
        public void onSuccess(@org.checkerframework.checker.nullness.qual.NonNull MediaType mediaType) {
            Objects.requireNonNull(mediaType);
            if (this.listener.isEnabled()) {
                this.listener.onWebSourceEvent(this.source, String.format("Parsing '%s'", mediaType));
            }
        }

        @Override
        public void onRedirection(URL oldUrl, URL newUrl) {
            Objects.requireNonNull(oldUrl);
            Objects.requireNonNull(newUrl);
            if (this.listener.isEnabled()) {
                this.listener.onWebSourceEvent(this.source, SdmxWebEvents.onRedirection((URL)oldUrl, (URL)newUrl));
            }
        }

        @Override
        public void onUnauthorized(URL url, HttpAuthScheme oldScheme, HttpAuthScheme newScheme) {
            Objects.requireNonNull(url);
            Objects.requireNonNull(oldScheme);
            Objects.requireNonNull(newScheme);
            if (this.listener.isEnabled()) {
                this.listener.onWebSourceEvent(this.source, String.format("Authenticating %s with '%s'", url, newScheme.name()));
            }
        }

        @Override
        public void onEvent(@org.checkerframework.checker.nullness.qual.NonNull String message) {
            Objects.requireNonNull(message);
            if (this.listener.isEnabled()) {
                this.listener.onWebSourceEvent(this.source, message);
            }
        }

        @Generated
        public RiHttpEventListener(@NonNull SdmxWebSource source, @NonNull SdmxWebListener listener) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.source = source;
            this.listener = listener;
        }
    }
}

