/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.web;

import internal.sdmxdl.ri.web.RiHttpUtils;
import internal.sdmxdl.ri.web.RiRestParsers;
import internal.util.http.MediaType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nbbrd.io.FileParser;
import org.checkerframework.checker.nullness.qual.NonNull;
import sdmxdl.Codelist;
import sdmxdl.CodelistRef;
import sdmxdl.DataCursor;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.ObsFactory;
import sdmxdl.xml.stream.SdmxXmlStreams;

public class DotStatRestParsers
implements RiRestParsers {
    @Override
    public @NonNull List<MediaType> getFlowsTypes() {
        return Collections.singletonList(RiHttpUtils.GENERIC_XML_TYPE);
    }

    @Override
    public @NonNull FileParser<List<Dataflow>> getFlowsParser(@NonNull MediaType mediaType, @NonNull LanguagePriorityList langs) {
        return SdmxXmlStreams.struct20((LanguagePriorityList)langs).andThen(structs -> structs.stream().map(DotStatRestParsers::getFlowFromStructure).collect(Collectors.toList()));
    }

    @Override
    public @NonNull List<MediaType> getFlowTypes() {
        return Collections.singletonList(RiHttpUtils.GENERIC_XML_TYPE);
    }

    @Override
    public @NonNull FileParser<Optional<Dataflow>> getFlowParser(@NonNull MediaType mediaType, @NonNull LanguagePriorityList langs, @NonNull DataflowRef ref) {
        return SdmxXmlStreams.struct20((LanguagePriorityList)langs).andThen(structs -> structs.stream().map(DotStatRestParsers::getFlowFromStructure).findFirst());
    }

    @Override
    public @NonNull List<MediaType> getStructureTypes() {
        return Collections.singletonList(RiHttpUtils.STRUCTURE_21_TYPE);
    }

    @Override
    public @NonNull FileParser<Optional<DataStructure>> getStructureParser(@NonNull MediaType mediaType, @NonNull LanguagePriorityList langs, @NonNull DataStructureRef ref) {
        return SdmxXmlStreams.struct20((LanguagePriorityList)langs).andThen(structs -> structs.stream().findFirst());
    }

    @Override
    public @NonNull List<MediaType> getDataTypes() {
        return Collections.singletonList(RiHttpUtils.STRUCTURE_SPECIFIC_DATA_20_TYPE);
    }

    @Override
    public @NonNull FileParser<DataCursor> getDataParser(@NonNull MediaType mediaType, @NonNull DataStructure dsd, @NonNull ObsFactory dataFactory) {
        DataStructure modifiedDsd = dsd.toBuilder().timeDimensionId("TIME").build();
        return SdmxXmlStreams.compactData20((DataStructure)modifiedDsd, (ObsFactory)dataFactory);
    }

    @Override
    public @NonNull List<MediaType> getCodelistTypes() {
        throw new UnsupportedOperationException("codelist");
    }

    @Override
    public @NonNull FileParser<Optional<Codelist>> getCodelistParser(@NonNull MediaType mediaType, @NonNull LanguagePriorityList langs, @NonNull CodelistRef ref) {
        throw new UnsupportedOperationException("codelist");
    }

    public static @NonNull Dataflow getFlowFromStructure(@NonNull DataStructure o) {
        return Dataflow.of((DataflowRef)DotStatRestParsers.getFlowRefFromStructureRef(o.getRef()), (DataStructureRef)o.getRef(), (String)o.getLabel());
    }

    public static @NonNull DataflowRef getFlowRefFromStructureRef(@NonNull DataStructureRef o) {
        return DataflowRef.of((String)o.getAgency(), (String)o.getId(), (String)o.getVersion());
    }
}

