/*
 * Decompiled with CFR 0.152.
 */
package internal.sdmxdl.ri.file.readers;

import internal.sdmxdl.ri.file.XmlDecoder;
import internal.sdmxdl.ri.file.XmlFileClient;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.LanguagePriorityList;
import sdmxdl.ext.SdmxCache;
import sdmxdl.file.SdmxFileConnection;
import sdmxdl.file.SdmxFileSource;
import sdmxdl.file.spi.SdmxFileContext;
import sdmxdl.file.spi.SdmxFileReader;
import sdmxdl.util.file.CachedFileClient;
import sdmxdl.util.file.SdmxFileClient;
import sdmxdl.util.file.SdmxFileConnectionImpl;
import sdmxdl.util.parser.ObsFactories;
import sdmxdl.xml.XmlFileSource;

public class XmlFileReader
implements SdmxFileReader {
    private static final DataStructureRef EMPTY = DataStructureRef.of((String)"", (String)"", (String)"");

    public SdmxFileSource getSource(String name) {
        try {
            return (SdmxFileSource)XmlFileSource.getParser().parseChars((CharSequence)name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public boolean canRead(SdmxFileSource source) {
        return this.isXmlFileName(source.getData());
    }

    public SdmxFileConnection read(SdmxFileSource source, SdmxFileContext context) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(context);
        if (!this.canRead(source)) {
            throw new IllegalArgumentException(source.toString());
        }
        return new SdmxFileConnectionImpl(this.getClient(source, context), this.getDataflow(source));
    }

    private boolean isXmlFileName(File file) {
        return file.toString().toLowerCase(Locale.ROOT).endsWith(".xml");
    }

    private SdmxFileClient getClient(SdmxFileSource source, SdmxFileContext context) throws IOException {
        XmlFileClient client = new XmlFileClient(source, context.getLanguages(), new XmlDecoder(context.getEventListener()), ObsFactories.getObsFactory((SdmxFileContext)context, (SdmxFileSource)source), context.getEventListener());
        return CachedFileClient.of((SdmxFileClient)client, (SdmxCache)context.getCache(), (SdmxFileSource)source, (LanguagePriorityList)context.getLanguages());
    }

    private Dataflow getDataflow(SdmxFileSource source) {
        return Dataflow.of((DataflowRef)source.asDataflowRef(), (DataStructureRef)EMPTY, (String)SdmxFileSource.asFlowLabel((SdmxFileSource)source));
    }
}

